/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.modeleditor.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.Constants.EventGatewayType;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common.CoreBPMNElement;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.editormodels.EventBasedGatewayEditorModel;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.EnclosedFieldMappingPolicy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.IInstantiationHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.UIBindingManager;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.ListUIField;
import com.google.gwt.user.client.ui.Widget;

public class EventBasedGatewayFormTemplate extends CommonFormTemplate {

	public EventBasedGatewayFormTemplate(CoreBPMNElement bpmnElement) {
		super(bpmnElement);
	}

	@Override
	protected List<LabelWidgetPair> getPairs() {
		ArrayList<LabelWidgetPair> result = new ArrayList<LabelWidgetPair>();	
		
		result.addAll(super.getPairs());
		
		Widget instantiate = (Widget) this.getUIField("instantiate"); 
		Widget type		   = (Widget) this.getUIField("type");
		
		if (instantiate!=null) result.add(new LabelWidgetPair("Instantiate", instantiate));
		
		if (type!=null) result.add(new LabelWidgetPair("Type", type));
		
		
		
		return result;
	}

	@Override
	protected void initMappingPolicies() {
		
		EnclosedFieldMappingPolicy efmp1 = new EnclosedFieldMappingPolicy(EventBasedGatewayEditorModel.class, "type", new IInstantiationHandler<ListUIField<EventGatewayType>>() {
			
			@Override
			public ListUIField<EventGatewayType> instantiate() {
		
				return new ListUIField<EventGatewayType>(Arrays.asList(EventGatewayType.values()));
			}
		
		});
		
		UIBindingManager.getInstance().addClassMappingPolicy(efmp1);
		
	}

}
