/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.modeleditor.template;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IPartnerRoleBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common.CoreBPMNElement;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.editormodels.PoolEditorModel;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.EnclosedFieldMappingPolicy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.IInstantiationHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.UIBindingManager;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.MultipleChoiceListUIField;
import com.google.gwt.user.client.ui.Widget;

public class PoolFormTemplate extends CommonFormTemplate {

	public PoolFormTemplate(CoreBPMNElement bpmnElement) {
		super(bpmnElement);
	}

	@Override
	protected List<LabelWidgetPair> getPairs() {
		ArrayList<LabelWidgetPair> result = new ArrayList<LabelWidgetPair>();	
		
		result.addAll(super.getPairs());
		
		Widget partnerRoles = (Widget) this.getUIField("partnerRoleIds"); 
		
		Widget interfaces = (Widget) this.getUIField("interfaces");
		
		Widget multiplicityMin = (Widget) this.getUIField("participantMultiplicityMin");
		
		Widget multiplicityMax = (Widget) this.getUIField("participantMultiplicityMax");
		
		if (partnerRoles!=null) result.add(new LabelWidgetPair("Partner Roles", partnerRoles));
		
		if (interfaces!=null) result.add(new LabelWidgetPair("Interfaces", interfaces));
		
		if (multiplicityMin!=null) result.add(new LabelWidgetPair("Multiplicity Min.", multiplicityMin));
		
		if (multiplicityMax!=null) result.add(new LabelWidgetPair("Multiplicity Max.", multiplicityMax));
		
		return result;
	}
	
	
	
	@Override
	protected void initMappingPolicies() {
		
		IDefinitionsBean defs  = (IDefinitionsBean) getBpmnElement().getMainModel();
		
		final List<IPartnerRoleBean> partnerRoles = defs.getPartnerRoles();
		final List<IInterfaceBean> interfaces = defs.getInterfaces();
		

		
		EnclosedFieldMappingPolicy efmp1 = new EnclosedFieldMappingPolicy(PoolEditorModel.class, "partnerRoleIds", new IInstantiationHandler<MultipleChoiceListUIField<List<IPartnerRoleBean>,IPartnerRoleBean>>() {
			
			@Override
			public MultipleChoiceListUIField<List<IPartnerRoleBean>, IPartnerRoleBean> instantiate() {
				
				MultipleChoiceListUIField<List<IPartnerRoleBean>,IPartnerRoleBean> mcluf1 = new MultipleChoiceListUIField<List<IPartnerRoleBean>,IPartnerRoleBean>(partnerRoles);
				
				return mcluf1; 
			}
		
		});
		
		
		EnclosedFieldMappingPolicy efmp2 = new EnclosedFieldMappingPolicy(PoolEditorModel.class, "interfaces", new IInstantiationHandler<MultipleChoiceListUIField<List<IInterfaceBean>,IInterfaceBean>>() {
			@Override
			public MultipleChoiceListUIField<List<IInterfaceBean>, IInterfaceBean> instantiate() {
				
				return new MultipleChoiceListUIField<List<IInterfaceBean>,IInterfaceBean>(interfaces);
			}
		});
		
		UIBindingManager.getInstance().addClassMappingPolicy(efmp1);
		UIBindingManager.getInstance().addClassMappingPolicy(efmp2);
		
	}


}
