/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.modeleditor.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.Constants.TaskType;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.service.IOperationBean;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common.CoreBPMNElement;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.editormodels.TaskEditorModel;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.EnclosedFieldMappingPolicy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.IInstantiationHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.UIBindingManager;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.ListUIField;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.events.DisplayEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.events.IUIFieldHandler;
import com.google.gwt.user.client.ui.Widget;

public class TaskFormTemplate extends ActivityFormTemplate {
	

	private List<IMessageBean> messages;
	private List<IOperationBean> operations;
	
	
	public TaskFormTemplate(CoreBPMNElement bpmnElement) {
		super(bpmnElement);
	}

	@Override
	protected List<LabelWidgetPair> getPairs() {
		ArrayList<LabelWidgetPair> result = new ArrayList<LabelWidgetPair>();	
		
		result.addAll(super.getPairs());
		
		Widget taskType = (Widget) this.getUIField("taskType"); 
		

		
		if (taskType!=null) result.add(new LabelWidgetPair("Type", taskType));
		

		
		//add operation + message + implementation if task type ==  Send || Receive
		TaskType type = ((TaskEditorModel)getBpmnElement().getEditorModel()).getTaskType(); 
		
		if (type==TaskType.SEND_TASK || type==TaskType.RECEIVE_TASK){
			
			
			Widget message = (Widget) this.getUIField("message");
			
			Widget operation = (Widget) this.getUIField("operation");
			
			Widget implementation = (Widget) this.getUIField("implementation");
			
			if (message!=null) result.add(new LabelWidgetPair("Message", message));
			
			if (operation!=null) result.add(new LabelWidgetPair("Operation", operation));
			
			if (implementation!=null) result.add(new LabelWidgetPair("Implementation", implementation));
		
		}
		
		//add operation + implementation if tasktype == Service
		if (type==TaskType.SERVICE_TASK){
			
			Widget operation = (Widget) this.getUIField("operation");
			
			Widget implementation = (Widget) this.getUIField("implementation");

			if (operation!=null) result.add(new LabelWidgetPair("Operation", operation));
			
			if (implementation!=null) result.add(new LabelWidgetPair("Implementation", implementation));
			
		}
		
		
		if (type==TaskType.RECEIVE_TASK){
			
			Widget instantiate  = (Widget) this.getUIField("instantiate");
			
			if (instantiate!=null) result.add(new LabelWidgetPair("Instantiate", instantiate));
		}
		
		return result;
	}

	@Override
	protected void initMappingPolicies() {
		super.initMappingPolicies();
		
		IDefinitionsBean defs  = (IDefinitionsBean) getBpmnElement().getMainModel();
		 
		
		this.messages = defs.getMessages();
		this.operations = defs.getOperations();
		

		///////////Message Ref
		EnclosedFieldMappingPolicy efmp2 = new EnclosedFieldMappingPolicy(TaskEditorModel.class, "message", new IInstantiationHandler<ListUIField<IMessageBean>>() {
			@Override
			public ListUIField<IMessageBean> instantiate() {
				
				final ListUIField<IMessageBean> msgList = new ListUIField<IMessageBean>(messages);
				msgList.addUIFieldHandler(new IUIFieldHandler() {
					
					@Override
					public void onDisplay(DisplayEvent event) {
						
						msgList.setOptions(messages);
						
					}
				});
				
				return msgList;
			}
		});
		
		UIBindingManager.getInstance().addClassMappingPolicy(efmp2);
		
		///////////Operation Ref
		EnclosedFieldMappingPolicy efmp3 = new EnclosedFieldMappingPolicy(TaskEditorModel.class, "operation", new IInstantiationHandler<ListUIField<IOperationBean>>() {
			@Override
			public ListUIField<IOperationBean> instantiate() {
				
				final ListUIField<IOperationBean> opList = new ListUIField<IOperationBean>(operations);
				opList.addUIFieldHandler(new IUIFieldHandler() {
					
					@Override
					public void onDisplay(DisplayEvent event) {
						
						opList.setOptions(operations);
						
					}
				});
				
				return opList;
			}
		});
		
		UIBindingManager.getInstance().addClassMappingPolicy(efmp3);
		
		
		//////////Task Type
		EnclosedFieldMappingPolicy efmp = new EnclosedFieldMappingPolicy(TaskEditorModel.class, "taskType", new IInstantiationHandler<ListUIField<TaskType>>() {
			@Override
			public ListUIField<TaskType> instantiate() {
				ListUIField<TaskType> taskTypeListBox = new ListUIField<TaskType>(Arrays.asList(TaskType.values()));
				return taskTypeListBox;
			}
		
		});
		
		UIBindingManager.getInstance().addClassMappingPolicy(efmp);
	
	}
	
	@Override
	public void refresh() {
		super.refresh();
		
		IDefinitionsBean defs  = (IDefinitionsBean) getBpmnElement().getMainModel();

		this.messages = defs.getMessages();
		this.operations = defs.getOperations();
	}
	
}
