/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.process.activities;

import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.BPMNElementsPath;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.DescriptiveProcessPanel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common.ConnectableFlowElement;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common.ContextualMenuHandler;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common.connector.ConnectionMode;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.modeleditor.template.AbstractTemplate;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Path;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasDragProxyContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.events.IDragProxyContextualMenuHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.contextualmenu.DragProxyContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyRefusedBeforeDropEvent;

public abstract class Activity extends ConnectableFlowElement implements IHasDragProxyContextualMenu{
	
	private boolean hasSubProcessMarker;
	private boolean hasLoopMarker;
	private boolean hasParallelMIMarker;
	private boolean hasSequentialMIMarker;
	private boolean hasAdHocMarker;
	private boolean hasCompensationMarker;
	
	private Path subProcessMarker;
	private Path loopMarker;
	private Path parallelMIMarker;
	private Path sequentialMIMarker;
	private Path adHocMarker;
	private Path compensationMarker;
	
	public Activity(DescriptiveProcessPanel definitionPanel,String id) {
		super(definitionPanel,id,ConnectionMode.ALL);
		//Add contextual menu ability
		DragProxyContextualMenu dpm = new DragProxyContextualMenu(this);
		
		this.addContextualMenuHandler(new ContextualMenuHandler(this));
	}

	@Override
	protected void init() {
		super.init();
		
		subProcessMarker 			= this.getDefinitionPanel().getCanvas().createPath(BPMNElementsPath.ACTIVITY_MARKER_SUBPROCESS_EXTENDED, 0, 0);
		loopMarker		 			= this.getDefinitionPanel().getCanvas().createPath(BPMNElementsPath.ACTIVITY_MARKER_LOOP, 0, 0); 
		parallelMIMarker		 	= this.getDefinitionPanel().getCanvas().createPath(BPMNElementsPath.ACTIVITY_MARKER_PARALLEL, 0, 0); 
		sequentialMIMarker		 	= this.getDefinitionPanel().getCanvas().createPath(BPMNElementsPath.ACTIVITY_MARKER_SEQUENCIAL, 0, 0); 
		adHocMarker		 			= this.getDefinitionPanel().getCanvas().createPath(BPMNElementsPath.ACTIVITY_MARKER_AD_HOC, 0, 0); 
		compensationMarker		 	= this.getDefinitionPanel().getCanvas().createPath(BPMNElementsPath.ACTIVITY_MARKER_COMPENSATION, 0, 0); 
	
		getGroup().appendChild(subProcessMarker);
		getGroup().appendChild(loopMarker);
		getGroup().appendChild(parallelMIMarker);
		getGroup().appendChild(sequentialMIMarker);
		getGroup().appendChild(adHocMarker);
		getGroup().appendChild(compensationMarker);
		
		subProcessMarker.setVisible(false);
		subProcessMarker.setStokeColour("#A4376B");
		subProcessMarker.setFillColour("#A4376B");
		
		loopMarker.setVisible(false);
		loopMarker.setStokeColour("#A4376B");
		loopMarker.setFillColour("#A4376B");
		
		
		parallelMIMarker.setVisible(false);
		parallelMIMarker.setStokeColour("#A4376B");
		parallelMIMarker.setFillColour("#A4376B");
		
		sequentialMIMarker.setVisible(false);
		sequentialMIMarker.setStokeColour("#A4376B");
		sequentialMIMarker.setFillColour("#A4376B");
		
		adHocMarker.setVisible(false);
		adHocMarker.setStokeColour("#A4376B");
		adHocMarker.setFillColour("#A4376B");
		
		compensationMarker.setVisible(false);
		compensationMarker.setStokeColour("#A4376B");
		compensationMarker.setFillColour("#A4376B");
		
	
	}
	
	public void addContextualMenuHandler(IDragProxyContextualMenuHandler handler) {
		handlerManager.addHandler(ProxyDragStartEvent.TYPE, handler);
		handlerManager.addHandler(ProxyDragMoveEvent.TYPE, handler);
		handlerManager.addHandler(ProxyDragStopEvent.TYPE, handler);
		handlerManager.addHandler(ProxyAcceptedBeforeDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyRefusedBeforeDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyAcceptedAfterDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyRefusedAfterDropEvent.TYPE, handler);	
	}
	
	
	public void hasSubProcessMarker(boolean b){
		this.hasSubProcessMarker = b;
		processMarkers();
	}
	
	public void hasLoopMarker(boolean b){
		this.hasLoopMarker = b;
		processMarkers();
	}

	public void hasParallelMIMarker(boolean b){
		this.hasParallelMIMarker = b;
		processMarkers();
	}

	public void hasSequentialMIMarker(boolean b){
		this.hasSequentialMIMarker = b;
		processMarkers();
	}
	
	public void hasAdHocMarker(boolean b){
		this.hasAdHocMarker = b;
		processMarkers();
	}
	
	public void hasCompensationMarker(boolean b){
		this.hasCompensationMarker = b;
		processMarkers();
	}
	
	public boolean hasSubProcessMarker(){
		return this.hasSubProcessMarker;
	}
	
	public boolean hasLoopMarker(){
		return this.hasLoopMarker;
	}
	
	public boolean hasParallelMIMarker(){
		return this.hasParallelMIMarker;
	}
	
	public boolean hasSequentialMIMarker(){
		return this.hasSequentialMIMarker;
	}
	
	public boolean hasAdHocMarker(){
		return this.hasAdHocMarker;
	}
	
	public boolean hasCompensationMarker(){
		return this.hasCompensationMarker;
	}
	
	
	private void processMarkers(){
		
		float activityMiddle = this.getWidth()/2;
		
		float totalMarkerWidth = 0;
		float markerWidth = 20;
		float markerHeight = 20;
		
		if (hasSubProcessMarker){
			totalMarkerWidth = totalMarkerWidth + markerWidth;
		}
		if (hasLoopMarker){
			totalMarkerWidth = totalMarkerWidth + markerWidth;
		}
		if (hasParallelMIMarker){
			totalMarkerWidth = totalMarkerWidth + markerWidth;
		}
		if (hasSequentialMIMarker){
			totalMarkerWidth = totalMarkerWidth + markerWidth;
		}
		if (hasAdHocMarker){
			totalMarkerWidth = totalMarkerWidth + markerWidth; 
		}
		if (hasCompensationMarker){
			totalMarkerWidth = totalMarkerWidth + markerWidth;
		}
		
		
		float totalMarkerWidthMiddle = totalMarkerWidth/2;
		
		float startDisplayX = activityMiddle - totalMarkerWidthMiddle;
		float startDisplayY = this.getHeight() - markerHeight ;
		
		float actualX = startDisplayX;
		if (hasSubProcessMarker){
			subProcessMarker.setX(actualX);
			subProcessMarker.setY(startDisplayY);
			actualX = actualX + markerWidth;
			subProcessMarker.setVisible(true);
		}else{
			subProcessMarker.setVisible(false);
		}
		
		if (hasLoopMarker){
			loopMarker.setX(actualX);
			loopMarker.setY(startDisplayY);
			actualX = actualX + markerWidth;
			loopMarker.setVisible(true);
		}else{
			loopMarker.setVisible(false);
		}
		
		if (hasParallelMIMarker){
			parallelMIMarker.setX(actualX);
			parallelMIMarker.setY(startDisplayY);
			
			actualX = actualX + markerWidth;
			parallelMIMarker.setVisible(true);
		}else{
			parallelMIMarker.setVisible(false);
		}
		
		if (hasSequentialMIMarker){
			sequentialMIMarker.setX(actualX);
			sequentialMIMarker.setY(startDisplayY);
			actualX = actualX + markerWidth;
			sequentialMIMarker.setVisible(true);
		}else{
			sequentialMIMarker.setVisible(false);
		}
		
		if (hasAdHocMarker){
			adHocMarker.setX(actualX);
			adHocMarker.setY(startDisplayY);
			actualX = actualX + markerWidth;
			adHocMarker.setVisible(true);
		}else{
			adHocMarker.setVisible(false);
		}
		
		if (hasCompensationMarker){
			compensationMarker.setX(actualX);
			compensationMarker.setY(startDisplayY);
			actualX = actualX + markerWidth;
			compensationMarker.setVisible(true);
		}else{
			compensationMarker.setVisible(false);
		}
		
	}

}
