/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.process.activities;

import java.util.HashSet;
import java.util.LinkedHashSet;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.Constants.TaskType;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.BPMNElementsPath;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.DescriptiveProcessPanel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.connectors.SequenceFlow;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.activities.TaskMenuDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.connectors.SequenceFlowMenuDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.events.EndNoneMenuDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.gateways.ExclusiveGatewayMenuDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.editormodels.TaskEditorModel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.modeleditor.template.TaskFormTemplate;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicState;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.syntax.IDiagramElementSyntaxModelBinder;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Path;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Rectangle;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElementDefaulHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasMenuDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.core.Direction;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOutEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.ConnectableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DraggableProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.AbstractUITemplate;
import com.google.gwt.core.client.GWT;


public class Task extends Activity{

	
	private Rectangle rectangle;

	private String DEFAULT_LABEL = "New Task";
	public static TaskType DEFAULT_TYPE = TaskType.NONE;

	private Path sendType;
	private Path receiveType;
	private Path userType;
	private Path manualType;
	private Path businessRuleType;
	private Path serviceType;
	private Path scriptType;
	
	private TaskType taskType;
	
	//Editor model
	private TaskEditorModel taskEditorModel;

	
	private HashSet<IDiagramElementViewConformityRule>  rules;
	
	private IConnectableElementDefaulHandlers defaultHandlers;
	

	
	public Task(DescriptiveProcessPanel definitionPanel,String id) {
		super(definitionPanel,id);

		
		//Attach default handlers on load as 
		this.defaultHandlers	= new ConnectableElementDefaultHandlers(this);
		this.defaultHandlers.attachDefaultHandlers();
		
		this.rules = new HashSet<IDiagramElementViewConformityRule>();
		
		TaskRules r = new TaskRules();
		
		//rules.add(r.new SendTaskMustHaveAnOutgoingMessageFlow());
		this.addDropHandler(this);
	}
	
	public String getName() {
		return "Task";
	}

	@Override
	protected void init() {
		super.init();
		
		this.label  = this.getDefinitionPanel().getCanvas().createText(50, 25, DEFAULT_LABEL);
		this.getGroup().appendChild(label);
	
	
		sendType  = this.getDefinitionPanel().getCanvas().createPath(BPMNElementsPath.TASK_MARKER_SEND, 0, 0);
		receiveType = this.getDefinitionPanel().getCanvas().createPath(BPMNElementsPath.TASK_MARKER_RECEIVE, 0, 0);;
		userType = this.getDefinitionPanel().getCanvas().createPath(BPMNElementsPath.TASK_MARKER_USER, 0, 0); ;
		manualType = this.getDefinitionPanel().getCanvas().createPath(BPMNElementsPath.TASK_MARKER_MANUAL, 0, 0);;
		businessRuleType = this.getDefinitionPanel().getCanvas().createPath(BPMNElementsPath.TASK_MARKER_BUSINESS_RULE, 0, 0);;
		serviceType= this.getDefinitionPanel().getCanvas().createPath(BPMNElementsPath.TASK_MARKER_SERVICE, 0, 0);;
		scriptType= this.getDefinitionPanel().getCanvas().createPath(BPMNElementsPath.TASK_MARKER_SCRIPT, 0, 0);;
	
		sendType.setFillColour("#A4376B");
		sendType.setStokeColour("#A4376B");
		sendType.setVisible(false);
		sendType.translate(5, 5);
		
		receiveType.setFillColour("#A4376B");
		receiveType.setStokeColour("#A4376B");
		receiveType.setVisible(false);
		receiveType.translate(5, 5);
		
		userType.setFillColour("#A4376B");
		userType.setStokeColour("#A4376B");
		userType.setVisible(false);
		userType.translate(5, 5);
		
		manualType.setFillColour("#A4376B");
		manualType.setStokeColour("#A4376B");
		manualType.setVisible(false);
		manualType.translate(5, 5);
		
		businessRuleType.setFillColour("#A4376B");
		businessRuleType.setStokeColour("#A4376B");
		businessRuleType.setVisible(false);
		businessRuleType.translate(5, 5);
		
		serviceType.setFillColour("#A4376B");
		serviceType.setStokeColour("#A4376B");
		serviceType.setVisible(false);
		serviceType.translate(5,5);
		
		scriptType.setFillColour("#A4376B");
		scriptType.setStokeColour("#A4376B");
		scriptType.setVisible(false);
		scriptType.translate(5, 5);
		
		
		getGroup().appendChild(sendType);
		getGroup().appendChild(receiveType);
		getGroup().appendChild(userType);
		getGroup().appendChild(manualType);
		getGroup().appendChild(businessRuleType);
		getGroup().appendChild(scriptType);
		getGroup().appendChild(serviceType);
		
	
	
	}
	
	
	@Override
	public SVGElement getMainShape() {
		
		if (rectangle==null){
			rectangle = this.getDefinitionPanel().getCanvas().createRectangle(0, 0, 100, 50,5);
			rectangle.setFillColour("white");
			rectangle.setStokeColour("#A4376B");
		}
			
		return rectangle;
	}
	
	
	

	public HashSet<Class<? extends IDraggableElement>> getAcceptedTypes() {
		 HashSet<Class<? extends IDraggableElement>> result = new HashSet<Class<? extends IDraggableElement>>();
		
		 result.add(SequenceFlow.class);
		 
		 return result;
	}



	public void onDropAccepted(IDropAcceptedEvent event) {
		
		System.out.println("Task accepted drop:"+event.getDraggableElement().getClass());

		//if a sequence flow is dropped from a HasMenuDragProxy connect  
		if (event.getDraggableElement() instanceof DraggableProxy){
			
			DraggableProxy dp = (DraggableProxy) event.getDraggableElement();
			
			if (dp.getHasDraggableElementProxy() instanceof IHasMenuDragProxy){
				
				IHasMenuDragProxy hmdp = (IHasMenuDragProxy) (dp.getHasDraggableElementProxy());
				
				if (dp.getHasDraggableElementProxy().getIUIElementType()==SequenceFlow.class){
					
					SequenceFlow sf = (SequenceFlow) getUIPanel().getElementFactory().getElement(SequenceFlow.class);
					getUIPanel().addUIElement(sf);
					
					sf.connect((IConnectableElement) hmdp.getContextualMenuSubject(), this);
					
				}
				
			}
			
			
		}
		
		
	}


	public void onDropRefused(IDropRefusedEvent event) {
		
		System.out.println("Task refused drop");
		
	}


	public void onOut(IOutEvent event) {
		// TODO Auto-generated method stub
		
	}


	public void onOver(IOverEvent event) {
		// TODO Auto-generated method stub

			

			

		
	}





	public IEditorModel getEditorModel() {

		if (taskEditorModel==null){
			taskEditorModel = GWT.create(TaskEditorModel.class);
		}
		
		return taskEditorModel;
	}


	public HashSet<IDiagramElementGraphicState> getStates() {
		
		HashSet<IDiagramElementGraphicState> states = super.getStates();
		
		TaskStates ts = new TaskStates();
		
		states.add(ts.new TypeState());
		
		
		return states;
	}



	@Override
	public void refresh() {
		super.refresh();
	}
	
	public IConnectableElementDefaulHandlers getDefaultHandlers(){
		return defaultHandlers;
	}



	public LinkedHashSet<IHasMenuDragProxy> getDragProxies() {
		
		LinkedHashSet<IHasMenuDragProxy> dps = new LinkedHashSet<IHasMenuDragProxy>();
		
		TaskMenuDragProxy tdp = new TaskMenuDragProxy(this.getUIPanel());
		tdp.setLabelVisible(false);
		tdp.setSmallIcon(true);
		
		ExclusiveGatewayMenuDragProxy gdp = new ExclusiveGatewayMenuDragProxy(getUIPanel());
		gdp.setLabelVisible(false);
		gdp.setSmallIcon(true);
		
		EndNoneMenuDragProxy endNoneDragProxy = new EndNoneMenuDragProxy(getUIPanel());
		endNoneDragProxy.setLabelVisible(false);
		endNoneDragProxy.setSmallIcon(true);
		
		SequenceFlowMenuDragProxy sdp = new SequenceFlowMenuDragProxy(getUIPanel());
		sdp.setLabelVisible(false);
		sdp.setSmallIcon(true);
		
		dps.add(tdp);
		dps.add(gdp);
		dps.add(endNoneDragProxy);
		dps.add(sdp);
		
		return dps;
	}



	public Direction getMenuDirection() {
		// TODO Auto-generated method stub
		return null;
	}



	
	public void setType(TaskType type){
		this.taskType = type;
		processTaskType();
	}


	private void processTaskType(){
		
		sendType.setVisible(false);
		receiveType.setVisible(false);
		userType.setVisible(false);
		manualType.setVisible(false);
		businessRuleType.setVisible(false);
		serviceType.setVisible(false);
		scriptType.setVisible(false);
		
		
		
		if (taskType==TaskType.RECEIVE_TASK){
			receiveType.setVisible(true);
		}else if (taskType==TaskType.SEND_TASK){
			sendType.setVisible(true);
		}else if (taskType==TaskType.SERVICE_TASK){
			serviceType.setVisible(true);
		}
		
	}

	

	public IDiagramElementSyntaxModelBinder getSyntaxModelBinder() {

		return new TaskSyntaxModelBinder(this);
	}



	public void setIEditorView(IEditorView editorView) {
		// TODO Auto-generated method stub
		
	}



	public HashSet<IDiagramElementViewConformityRule> getConformityRules() {
		return rules;
	}



}
