/**
 * BPMN Diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmndiagram.business.domain.to;

import java.io.Serializable;

import com.ebmwebsourcing.bpmndiagram.business.domain.to.Constants.BPMNObjectType;



/**
 * This class is used to get all public informations about an user <br />
 * This class shouldn't be persisted
 * 
 * @author mcarpentier
 * 
 */
public class Flow implements Serializable {

    private static final long serialVersionUID = -4217847504186801919L;

    private String id;

    /** entity details* */
    private String name;
    private FlowNode sourceService;
    private FlowNode targetService;
    private BPMNObjectType flowType;

    public String getName() {
        return name;
    }

    public String getId() {
        return id;
    }
    
    public FlowNode getSourceService() {
        return sourceService;
    }
    
    public FlowNode getTargetService() {
        return targetService;
    }
    
    public BPMNObjectType getFlowType() {
        return flowType;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public void setId(final String id) {
        this.id = id;
    }
    
    public void setSourceService(final FlowNode sourceService) {
        this.sourceService = sourceService;
    }
    public void setTargetService(final FlowNode targetService) {
        this.targetService = targetService;
    }
    
    public void setFlowType(final BPMNObjectType flowType) {
        this.flowType = flowType;
    }
}
