/**
 * BPMN Diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.widget;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.MenuItemSeparator;
import com.google.gwt.user.client.ui.PopupPanel;

public class ContextMenu extends PopupPanel {

	private MenuBar menu;

	public ContextMenu() {
		super(true);
		menu = new MenuBar(true);
		menu.setVisible(true);

		setWidget(menu);

		getElement().getStyle().setZIndex(30000);

	}

	public MenuItem addItem(MenuItem item) {
		item.setCommand(new CommandWrapper(item.getCommand()));
		return menu.addItem(item);
	}


	public MenuItem addItem(String text, Command cmd) {


		return menu.addItem(text, new CommandWrapper(cmd));
	}

	public MenuItem addItem(String text, ContextMenuBar popup) {
		for (MenuItem item : popup.items()) {
			item.setCommand(new CommandWrapper(item.getCommand()));
		}
		return menu.addItem(text, popup);
	}

	public MenuItemSeparator addSeparator() {
		return menu.addSeparator();
	}

	public MenuItemSeparator addSeparator(MenuItemSeparator separator) {
		return menu.addSeparator(separator);
	}

	public void setAnimationEnabled(boolean enable) {
		menu.setAnimationEnabled(enable);
	}

	public void setAutoOpen(boolean autoOpen) {
		menu.setAutoOpen(autoOpen);
	}

	@Override
	public void hide() {
		super.hide();

	}
	
	
	// Command wrapper designed to hide the context popup
	private class CommandWrapper implements Command{

		private Command toExecute;
		
		public CommandWrapper(Command command) {
			toExecute = command;
		}
		
		public void execute() {
			hide();
			if (toExecute != null){
				toExecute.execute();
			}
			
		}
		
	}
	

}
