/**
 * BPMN Editor Collaborative client - A collaboration platform client for the BPMN Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.collaboration.comet.client.to.cometLogEntry;

import java.io.Serializable;

import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.foundation.FlowNodeElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.swimlane.LaneElement;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.foundation.GraphicElementBean;
import com.ebmwebsourcing.bpmneditor.presentation.gwt.client.bpmneditor.bpmn2.renderer.helper.DiagramToDefinitionsHelper;
import com.ebmwebsourcing.gwt.raphael.client.diagram.connector.DiagramConnector;
import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramElement;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.log.AbstractLogEntry;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.log.AddElementLogEntry;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.log.PropertyChangedLogEntry;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.log.RemoveElementLogEntry;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.log.UpdateElementLogEntry;
import com.google.gwt.user.client.ui.Widget;

public abstract class CometLogEntry implements Serializable{

	private String diagramElementId;
	private String modelId;
	
	
	public CometLogEntry(){}
	
	protected CometLogEntry(String diagramElementId, String modelId) {
		this.diagramElementId = diagramElementId;
		this.modelId = modelId;
	}
	
	
//	public abstract void execute(DrawingPanel dp);
	
	protected boolean checkIds(CometLogEntry other){
		return diagramElementId.equals(other.getDiagramElementId()) && modelId.equals(other.getModelId());
	}
	
	public abstract boolean isSimilar(CometLogEntry other);
	
	
	
	public static CometLogEntry adapt(AbstractLogEntry ale){
		String eiId = null;
		Widget vi = ale.getElementInstance().getViewInstance();
		if(vi instanceof DiagramElement){
			eiId = ((DiagramElement) vi).getId();
		}
		if(vi instanceof DiagramConnector){
			eiId = ((DiagramConnector) vi).getId();
		}
		
		String dpId = ale.getLog().getDrawingPanel().getSyntaxModel().getId();
		
		
		if(ale instanceof AddElementLogEntry){
			GraphicElementBean geb = new DiagramToDefinitionsHelper().getBean(ale.getElementInstance());
			return new AddElementCometLogEntry(eiId, dpId, geb, getParentId(vi));
		}
		
		else if(ale instanceof RemoveElementLogEntry){
			RemoveElementLogEntry rele = (RemoveElementLogEntry) ale;
			return new RemoveElementCometLogEntry(eiId,dpId,rele.getX(),rele.getY());
		}
		
		else if(ale instanceof UpdateElementLogEntry){
			if(vi instanceof DiagramElement){
				DiagramElement de = (DiagramElement) vi;
				return new UpdateElementCometLogEntry(eiId, dpId, getParentId(vi), de.getX(), de.getY());
			}
			else if(vi instanceof DiagramConnector){
				DiagramConnector dc = (DiagramConnector) vi;
				return new UpdateConnectorCometLogEntry(eiId,dpId,dc.getSource().getConnectableElement().getId()
						,dc.getTarget().getConnectableElement().getId());
			}
		}
		
		else if(ale instanceof PropertyChangedLogEntry){
			GraphicElementBean geb = new DiagramToDefinitionsHelper().getBean(ale.getElementInstance());
			return new PropertyChangedCometLogEntry(eiId, dpId, geb);
		}
			
		return null;
	}
	
	
	
	private static String getParentId(Widget w){
		if(w instanceof LaneElement){
			return ((LaneElement)w).getParentPool().getId();
		}
		else if(w instanceof FlowNodeElement){
			return ((FlowNodeElement)w).getParentLane().getId();
		}
		else{
			return null;
		}
	}
	
	public String getDiagramElementId() {
		return diagramElementId;
	}

	public void setDiagramElementId(String diagramElementId) {
		this.diagramElementId = diagramElementId;
	}

	public String getModelId() {
		return modelId;
	}

	public void setModelId(String modelId) {
		this.modelId = modelId;
	}
	
}
