/**
 * BPMN Editor Collaborative client - A collaboration platform client for the BPMN Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.collaboration.comet.client.to.cometLogEntry;



public class UpdateElementCometLogEntry extends CometLogEntry {

	private String parentId;
	private int newX;
	private int newY;
	
	public UpdateElementCometLogEntry(){}
	
	public UpdateElementCometLogEntry(String diagramElementId, String modelId, String parentID, int newX, int newY){
		super(diagramElementId,modelId);
		this.parentId = parentID;
		this.newX = newX;
		this.newY = newY;
	}
	

	@Override
	public boolean isSimilar(CometLogEntry other) {
		if(other instanceof UpdateElementCometLogEntry){
			UpdateElementCometLogEntry e = (UpdateElementCometLogEntry) other;
			
			//TODO remove trace
			System.out.println(checkIds(other));
			System.out.println((e.newX==newX) +"  "+ new Integer(e.newX)+ "  "+new Integer(newX));
			System.out.println((e.newY==newY) +"  "+ new Integer(e.newY)+ "  "+new Integer(newY));
			System.out.println((parentId==null ? e.parentId==null : parentId.equals(e.parentId)));
	
			//TODO FIXME BEWARE THIS SHOULD NOT BE DONE LIKE THIS BUT WITH A ==
			// --->  e.newX==newX && e.newY==newY
			boolean b = ((e.newX-newX)*(e.newX-newX))<=1;
			b = b && ((e.newY-newY)*(e.newY-newY))<=1;
			
			return checkIds(other) && b
				&& (parentId==null ? e.parentId==null : parentId.equals(e.parentId));
		}
		return false;
	}
	

	public String getParentId() {
		return parentId;
	}

	public void setParentId(String parentId) {
		this.parentId = parentId;
	}

	public int getNewX() {
		return newX;
	}

	public void setNewX(int newX) {
		this.newX = newX;
	}

	public int getNewY() {
		return newY;
	}

	public void setNewY(int newY) {
		this.newY = newY;
	}

}
