/**
 * BPMN Editor Collaborative client - A collaboration platform client for the BPMN Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.collaboration.comet.client.ui;

import java.util.Collection;

import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.Collaboration;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.User;
import com.gwtext.client.data.SimpleStore;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.form.ComboBox;


public class ChangeMasterPanel extends Panel{

	private Collaboration collab;
	
	public ChangeMasterPanel(Collaboration collaboration){
		super();
		collab = collaboration;
		
		fillPanel();
	}
	
	private void fillPanel(){
		Collection<User> users = collab.getPresentParticipants().getUsers();
		Object[] data = new Object[users.size()-1];
		int i=0;
		for(User u : users){
			if(!collab.isMaster(u)){
				data[i] = u;
				i++;
			}
		}
		
		SimpleStore store = new SimpleStore("User", data);
		store.load();
		
		ComboBox cb = new ComboBox();  
		cb.setForceSelection(true);  
		cb.setMinChars(1);  
		cb.setFieldLabel("New Master");  
		cb.setStore(store);  
		cb.setDisplayField("User");  
		cb.setMode(ComboBox.LOCAL); 
		
		add(cb);
		
		Button button = new Button("Change");
		add(button);
	}
	
}
