/**
 * BPMN Editor Collaborative client - A collaboration platform client for the BPMN Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class UserGroup implements Serializable{

	private String name;
	private Set<User> users;
	
	public UserGroup(){
		users = new HashSet<User>();
	}
	
	public UserGroup(String name){
		this.name = name;
		users = new HashSet<User>();
	}
	
	public void addUser(User user){
		users.add(user);
	}
	
	public void removeUser(User user){
		for(User u : users){
			if(u.equals(user)){
				users.remove(u);
			}
		}
	}
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Collection<User> getUsers() {
		return users;
	}

	public boolean isInGroup(User user){
		for(User u : users){
			if(u.equals(user)){
				return true;
			}
		}
		return false;
	}

	public void setUsers(Set<User> users) {
		this.users = users;
	}
	
}
