/**
 * diagram-interchange - Diagram Interchange Domain - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api;

import java.util.LinkedHashSet;
import java.util.Set;

import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.extension.client.WithAttributeExtension;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.extension.client.WithObjectExtension;
import com.google.gwt.user.client.rpc.IsSerializable;


/**
 * DiagramElement is the abstract supertype of all elements that can be nested in
 * a diagram. It has two subtypes: Node and Edge.
 * 
 * @author nfleury
 *
 */
public interface IDiagramElement extends  IsSerializable, WithAttributeExtension, WithObjectExtension{
	
	String getId();//not part of OMG specification
	
	IDiagram getOwningDiagram();
	
	IDiagramElement getOwningElement();
	
	IModelElement getModelElement();
	
	void setModelElement(IModelElement modelElement);
	
	LinkedHashSet<IDiagramElement> getOwnedElements();
	
	IStyle getStyle();
	
	void addDiagramElement(IDiagramElement diagramElement);

	void removeDiagramElement(IDiagramElement diagramElement);
	
	void setOwningElement(IDiagramElement element);
	
	//not part of spec
	Set<IEdge> getIncomingEdges();
	
	Set<IEdge> getOutgoingEdges();
	
	void addIncomingEdge(IEdge edge);
	
	void addOutgoingEdge(IEdge edge);
	
}
