/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.impl.events.builder;

import com.ebmwebsourcing.geasytools.diagrameditor.api.events.builder.IBuildDiagramInterchangeCompleteEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.api.events.builder.IModelBuilderHandler;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.google.gwt.event.shared.GwtEvent;

public class BuildDiagramInterchangeCompleteEvent extends GwtEvent<IModelBuilderHandler> implements IBuildDiagramInterchangeCompleteEvent{
	
	public static Type<IModelBuilderHandler> TYPE = new Type<IModelBuilderHandler>();
	
	private IDiagramView diagram;
	
	public BuildDiagramInterchangeCompleteEvent(IDiagramView diagram) {
		this.diagram = diagram;
	}
	

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IModelBuilderHandler> getAssociatedType() {
		return TYPE;
	}

	public IDiagramView getDiagramView() {
		return diagram;
	}

	@Override
	protected void dispatch(IModelBuilderHandler handler) {
		handler.onBuildDiagramInterchangeComplete(this);
	}



}
