/**
 * geasy-svg - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasysvg.core.impl.raphael;

import com.ebmwebsourcing.geasytools.geasysvg.core.api.IText;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGElement;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Element;

public class TextJSNI extends SVGElementJSNI implements IText{
	
	
	protected native Element createTextJS(JavaScriptObject raphaelPaper,float x, float y,String txt)/*-{
	
		var txt = raphaelPaper.text(x,y,txt);
		
		this.@com.ebmwebsourcing.geasytools.geasysvg.core.impl.raphael.TextJSNI::setSvgElementJsObject(Lcom/google/gwt/core/client/JavaScriptObject;)(txt);
		
		return txt.node;

	}-*/;
	
	
	/**
	 * Getters
	 */

	@Override
	public String getFont() {return null;}

	@Override
	public String getFontFamily() {return null;}

	@Override
	public int getFontsize() {return 0;}

	@Override
	public String getText() {return null;}

	
	/**
	 * Setters
	 */
	
	@Override
	public void setFont(String font) {
		
		setFontJS(getSvgElementJsObject(),font);
		
	}

	@Override
	public void setFontFamily(String fontFamily) {
		
		setFontFamilyJS(getSvgElementJsObject(),fontFamily);
		
	}

	@Override
	public void setFontSize(int size) {
		
		setFontSizeJS(getSvgElementJsObject(),size);
		
	}

	@Override
	public void setText(String text) {
		
		setTextJS(getSvgElementJsObject(),text);
		
	}

	
	@Override
	public void setX(float x) {
		setXJS(getSvgElementJsObject(),x);
	}
	
	@Override
	public void setY(float y) {
		setYJS(getSvgElementJsObject(),y);
	}
	
	/**
	 * JSNI IMPL
	 */

	public native void setXJS(JavaScriptObject svgElement,float x)/*-{
	
	svgElement.attr("x",x);

	}-*/;
	
	
	public native void setYJS(JavaScriptObject svgElement,float y)/*-{
	
	svgElement.attr("y",y);

	}-*/;
	
	
	public native void setFontJS(JavaScriptObject svgElement,String font)/*-{
		
		svgElement.attr("font",font);
	
	}-*/;

	
	public native void setFontFamilyJS(JavaScriptObject svgElement,String fontFamily)/*-{
	
		svgElement.attr("font-family",fontFamily);
	
	}-*/;

	
	public native void setFontSizeJS(JavaScriptObject svgElement,int size)/*-{
	
		svgElement.attr("font-size",size);
	
	}-*/;

	
	public native void setTextJS(JavaScriptObject svgElement,String text)/*-{
	
		svgElement.attr("text",text);
	
	}-*/;
	
}
