/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.api.core;

import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;

public interface IUIElementFactory {

	/**
	 * Used to create a {@link IUIElement} when a {@link IHasDragProxy} is dropped <br>
	 * on a container. The main difference with {@link IUIElementFactory#getElement(Class)} <br>
	 * is that some specific data from the {@link IHasDragProxy} parameter may be used create <br>
	 * the {@link IUIElement} with some specific values, configuration or state
	 *   
	 * @param draggableProxyData
	 * @return
	 */
	IUIElement getElement(IHasDragProxy draggableProxyData);
	
	/**
	 * Create a new {@link IUIElement} given its type
	 * @param elementType
	 * @return
	 */
	IUIElement getElement(Class<? extends IUIElement> elementType);
	
	
	IUIPanel getUIPanel();
	
}
