/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.connectable;

import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElementDefaulHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorEnd;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorStart;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IMagnet;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOutEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.droppable.DropHandler;

public class ConnectableElementDefaultHandlers implements IConnectableElementDefaulHandlers{
	
	private IConnectableElement connectableElement;
	
	public ConnectableElementDefaultHandlers(IConnectableElement connectableElement) {
			this.connectableElement = connectableElement;
	}
	
	@Override
	public void attachDefaultHandlers() {
		
		if (connectableElement.getAcceptedTypes()!=null){
		connectableElement.getAcceptedTypes().add(IConnectorEnd.class);
		connectableElement.getAcceptedTypes().add(IConnectorStart.class);
		}else{
			throw new IllegalStateException("Accepted types is null, please initialize list in "+connectableElement);
		}
		
		if (connectableElement instanceof IDraggableElement){
			
			IDraggableElement draggable = (IDraggableElement) connectableElement;
			
			draggable.addDragHandler(new DragHandler() {
				
				@Override
				public void onStop(IDragStopEvent event) {
					connectableElement.refreshMagnets();
				}
				
				@Override
				public void onStart(IDragStartEvent event) {
					connectableElement.refreshMagnets();
				}
				
				@Override
				public void onMove(IDragMoveEvent event) {
					connectableElement.refreshMagnets();
				}

				@Override
				public void onAcceptedAfterDrop(IAcceptedAfterDropEvent event) {
					// TODO Auto-generated method stub
					
				}

				@Override
				public void onAcceptedBeforeDrop(IAcceptedBeforeDropEvent event) {
					// TODO Auto-generated method stub
					
				}

				@Override
				public void onRefusedAfterDrop(IRefusedAfterDropEvent event) {
					// TODO Auto-generated method stub
					
				}

				@Override
				public void onRefusedBeforeDrop(IRefusedBeforeDropEvent event) {
					// TODO Auto-generated method stub
					
				}
			});
			
		}
		
		this.connectableElement.addDropHandler(new DropHandler() {
			
			@Override
			public void onOver(IOverEvent event) {
				
			}
			
			@Override
			public void onOut(IOutEvent event) {

			}
			
			@Override
			public void onDropRefused(IDropRefusedEvent event) {

				
			}
			
			@Override
			public void onDropAccepted(IDropAcceptedEvent event) {

				if (event.getDraggableElement() instanceof IConnectorPoint){
					
					IConnectorPoint cp = (IConnectorPoint) event.getDraggableElement();
					
					//get closest magnet to actual connector point
					
					float minDx = -1;
					float minDy = -1;
					
					IMagnet closestMagnet = null;
					
					for(IMagnet m:connectableElement.getMagnets()){
						
						float dx = Math.abs(cp.getRelativeX() - m.getRelativeX());
						float dy = Math.abs(cp.getRelativeY() - m.getRelativeY());
						
						
						if (minDx==-1 && minDy==-1){
							
							minDx = dx;
							minDy = dy;
							
							closestMagnet = m; 
						}
						
						if (dx<=minDx && dy<=minDy){
							
							minDx = dx;
							minDy = dy;
							
							closestMagnet = m;
						}
						
					}
					
					cp.setRelativeX(closestMagnet.getRelativeX());
					cp.setRelativeY(closestMagnet.getRelativeY());
					
					
					//associate connection point to magnet
					cp.setConnectedToMagnet(closestMagnet);
					closestMagnet.addConnectorPoint(cp);
					
					if (cp instanceof IConnectorStart){
						
						connectableElement.getOutgoingConnectors().add(cp.getConnector());
						cp.getConnector().setSource(connectableElement);
						
						
						
					}else if (cp instanceof IConnectorEnd){
						
						connectableElement.getIncommingConnectors().add(cp.getConnector());
						cp.getConnector().setTarget(connectableElement);
						
						
					}	
					
					
					cp.getConnector().refresh();
				}
				
			}
		});
		
		
	}

	@Override
	public IConnectableElement getConnectableElement() {
		return connectableElement;
	}

}
