/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.core;

import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainer;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainerDefaultHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.IDroppableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;


public class ContainerDefaultHandler implements IContainerDefaultHandler {

	private IContainer container;
	private IUIPanel uiPanel;
	
	public ContainerDefaultHandler(IContainer container,IUIPanel uipanel) {
		this.container 	= container;
		this.uiPanel 	= uipanel;
	}

	@Override
	public void attachDefaultHandlers() {
		if (container instanceof IDroppableElement) {
			//handle children
			IDroppableElement el = (IDroppableElement) container;
			el.addDropHandler(new DefaultContainerChildHandler(container, uiPanel));
			
			if (el instanceof IDraggableElement){
				IDraggableElement del = (IDraggableElement) el;
				del.addDragHandler(new DefaultContainerConnectorHandler(container, uiPanel));
			}
		}
	}
	
	@Override
	public IContainer getContainer() {
		return container;
	}

}
