/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.api.palette;

import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxy;

public interface IPaletteGroup {

	String getName();
	
	IPaletteGroup getParentGroup();
	
	void addParentGroup(IPaletteGroup group);
	
	void addElement(IHasDragProxy dragProxy);
	
	LinkedHashSet<IHasDragProxy> getElements();
	
	void setParentGroup(IPaletteGroup group);
	
	/**
	 * Remove all elements from this group
	 * This is useful when the content of the group may change over time
	 * For instance, after retrieving a list of remote objects
	 */
	void clearGroup();
}
