/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events;

import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.IDroppableElement;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragHandler;
import com.google.gwt.event.shared.GwtEvent;

public class RefusedBeforeDropEvent extends GwtEvent<DragHandler> implements IRefusedBeforeDropEvent{
	
	public static Type<DragHandler> TYPE = new Type<DragHandler>();
	
	private IDroppableElement droppableElement;
	
	public RefusedBeforeDropEvent(IDroppableElement droppableElement) {
	
		this.droppableElement 	= droppableElement;
		
	}
	
	
	@Override
	protected void dispatch(DragHandler handler) {
		handler.onRefusedBeforeDrop(this);
		
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<DragHandler> getAssociatedType() {
		return TYPE;
	}

	

	@Override
	public IDroppableElement getDroppableElement() {
		return droppableElement;
	}

}
