/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;

import com.ebmwebsourcing.geasytools.geasygraph.api.INode;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnector;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IMagnet;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainer;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IMouseState;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IRegion;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.events.IContainerHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.IDDManager;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.IDroppableDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.IDroppableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.selectable.ISelectable;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IHasUIPanelResizeUIHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.ISelectionMarker;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.ISelector;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanelDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanelResizeUIHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUIPanelHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.events.AddUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.events.RemoveUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.droppable.DDManager;
import com.ebmwebsourcing.geasytools.geasyui.impl.droppable.DropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.droppable.DropHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.droppable.DropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.droppable.OutEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.droppable.OverEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.selectable.events.SelectEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.selectable.events.UnselectEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.uipanel.DefaultBottomResizeUIHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.uipanel.DefaultLeftResizeUIHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.uipanel.DefaultRightResizeUIHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.uipanel.DefaultTopResizeUIHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.uipanel.UIPanelDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.impl.uipanel.events.NewUIElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.uipanel.events.RemoveUIElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.uipanel.events.ResizeRequestEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.uipanel.events.SelectedElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.uipanel.events.UnselectedElementsEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.dom.client.ScrollEvent;
import com.google.gwt.event.dom.client.ScrollHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Event.NativePreviewEvent;
import com.google.gwt.user.client.Event.NativePreviewHandler;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;

public abstract class UIPanel extends Composite implements IUIPanel,IHasUIPanelResizeUIHandlers{
	
	private MouseState mouseState;
	
	//All elements of actual UIPanel => whether or not if they are physically attached
	//to actual container
	private LinkedHashMap<String, IUIElement> uiElements;
	
	//All children of actual container => elements that are physically
	//attached to actual container
	private LinkedHashMap<String, IUIElement> childrenUIElements;

	
	private HashMap<String, ISelectable> selectedUIElements;
	private DDManager ddManager;
	protected HandlerManager handlerManager;
	
	private HashSet<INode> nodes;
	
	private ISelectionMarker selectionMarker;
	private ISelector selector;
	
	private IPoint northWestPoint;
	private IPoint southEastPoint;
	
	private UIPanelDefaultHandlers defaultHandlers;
	
	protected AbsolutePanel mainPanel;
	
	//Resize
	private IUIPanelResizeUIHandler topResizeHandler;
	private IUIPanelResizeUIHandler bottomResizeHandler;
	private IUIPanelResizeUIHandler leftResizeHandler;
	private IUIPanelResizeUIHandler rightResizeHandler;
	
	public UIPanel(String id) {
	
		this.mainPanel			= new AbsolutePanel();
		
		initWidget(mainPanel);
		
		this.defaultHandlers = new UIPanelDefaultHandlers(this);
		defaultHandlers.attachDefaultHandlers();
		
		this.mouseState 		= new MouseState();

		this.uiElements			= new LinkedHashMap<String, IUIElement>();
		this.childrenUIElements = new LinkedHashMap<String, IUIElement>();
		
		this.selectedUIElements = new HashMap<String, ISelectable>();
		
		this.nodes				= new HashSet<INode>();
		
		this.ddManager			= new DDManager(this);
		
		this.handlerManager 	= new HandlerManager(this);
		

		//Resize handlers

		
		this.mainPanel.add((Widget) getTopResizeHandler());
		this.mainPanel.add((Widget) getBottomResizeHandler());
		this.mainPanel.add((Widget) getLeftResizeHandler());
		this.mainPanel.add((Widget) getRightResizeHandler());
		
		this.refreshUIHandlers();
		
		
		NativePreviewHandler nph = new NativePreviewHandler() {
			
			@Override
			public void onPreviewNativeEvent(NativePreviewEvent event) {
				
				if (event.getTypeInt()==Event.ONKEYPRESS){
				
					if (event.getNativeEvent().getKeyCode()==KeyCodes.KEY_DELETE){
						removeSelectedElements();
					}
					
				}
				
			}
		}; 
		
		
		Event.addNativePreviewHandler(nph);
		
		

	}
	

	
	
	protected AbsolutePanel getMainPanel(){
		return this.mainPanel;
	}
	
	public void fireEvent(GwtEvent<?> event) {
		super.fireEvent(event);
		handlerManager.fireEvent(event);
	}

	@Override
	public int getScrollTop() {
		return this.getElement().getScrollTop();
	}
	
	@Override
	public int getScrollLeft() {
		return this.getElement().getScrollLeft();
	}


	public void addUIElement(IUIElement uiElement) {

		if (uiElements.containsValue(uiElement)==false){
			this.fireEvent(new NewUIElementsEvent(uiElement));
			uiElement.setUIPanel(this);
			uiElement.setContainer(this);
			this.uiElements.put(uiElement.getId(), uiElement);
			if (uiElement instanceof UIElement) ((UIElement)uiElement).onAttach();
			//select the element
			if (uiElement instanceof ISelectable){
				HashMap<String, ISelectable> selectedElements = new HashMap<String, ISelectable>();
				selectedElements.put(uiElement.getId(), (ISelectable) uiElement);
				this.setSelectedElements(selectedElements);
			}
		}
	
		if (this.childrenUIElements.containsValue(uiElement)==false){
			this.childrenUIElements.put(uiElement.getId(), uiElement);
			this.fireEvent(new AddUIElementEvent(uiElement));
		}
		
		uiElement.refresh();
		
	}
	
	
	public IUIElement getUIElementById(String id) {
		return uiElements.get(id);
	}
	
	
	public void setSelectedElements(HashMap<String,ISelectable> selectedElements) {
		//fire unselect event
		this.fireEvent(new UnselectedElementsEvent(selectedUIElements));

		//fire event on each selectable
		for(ISelectable selectable:this.selectedUIElements.values()){
			
			selectable.fireEvent(new UnselectEvent());
			
		}
		
		this.selectedUIElements = selectedElements;
		
		//fire event on each selectable
		for(ISelectable selectable:selectedElements.values()){
			
			selectable.fireEvent(new SelectEvent());
			
		}
		
		//fire event on panel
		this.fireEvent(new SelectedElementsEvent(selectedElements));
	}
	
	/**
	 * As UI is not loaded yet width and height are
	 * not set yet. We have to wait current element to be loaded
	 */
	@Override
	protected void onLoad() {
		super.onLoad();
		

		Timer t = new Timer() {
			
			@Override
			public void run() {
				
				getTopResizeHandler().refresh();
				getBottomResizeHandler().refresh();
				getLeftResizeHandler().refresh();
				getRightResizeHandler().refresh();
				refreshUIHandlers();
			
			}
		};
		
		t.schedule(1000);
		
		
	}
	



	
	public float getAbsoluteX() {
		return this.getElement().getAbsoluteLeft();
	}
	
	public float getAbsoluteY() {
		return this.getElement().getAbsoluteTop();
	}



	public IDDManager getDDManager() {
		return ddManager;
	}
	
	@Override
	public IUIPanelDefaultHandlers getDefaultHandlers() {
		return defaultHandlers;
	}

	public int getHeight() {
		return this.getElement().getOffsetHeight();
	}



	public int getWidth() {
		return this.getElement().getOffsetWidth();
	}
	
	
	@Override
	public int getClientHeight() {
		return this.getElement().getClientHeight();
	}
	
	@Override
	public int getClientWidth() {
		return this.getElement().getClientWidth();
	}
	
	public IMouseState getMouseState() {
		return mouseState;
	}

	@Override
	public HashMap<String, ISelectable> getSelectedElements() {
		return selectedUIElements;
	}

	public ISelectionMarker getSelectionMarker() {
		return selectionMarker;
	}

	@Override
	public ISelector getSelector() {
		return selector;
	}

	@Override
	public LinkedHashMap<String, IUIElement> getUIElements() {
		return uiElements;
	}
	
	public LinkedHashMap<String, IUIElement> getChildrenUIElements() {
		return childrenUIElements;
	}
	
	public void removeSelectionMarker() {

			if (selectionMarker!=null){
				mainPanel.remove((Widget) selectionMarker);
				this.selectionMarker = null;
			}

	}

	public void removeSelector() {

		if (selector!=null){
			mainPanel.remove((Widget) selector);
			this.selector = null;
		}

	}
	
	
	@Override
	public void removeSelectedElements() {
		
		for(IUIElement selectedEl:selectedUIElements.values()){
			
			this.removeElement(selectedEl);

		}
		
		this.removeSelectionMarker();
		this.unSelectAllEments();
	}
	
	public void setSelectionMarker(ISelectionMarker selectionMarker, int x,
			int y) {
		
			if (this.selectionMarker==null){
				mainPanel.add((Widget) selectionMarker, x, y);
				this.selectionMarker = selectionMarker;
			}else{
				mainPanel.setWidgetPosition((Widget) this.selectionMarker, x, y);
			}

	}
	

	public void setSelector(ISelector selector, int x, int y) {
		
			if (this.selector==null){
				mainPanel.add((Widget) selector,x,y);
				this.selector = selector;
				
			}else{
				mainPanel.setWidgetPosition((Widget)this.selector, x, y);
			}

	}

	public void unSelectAllEments() {
		
		this.fireEvent(new UnselectedElementsEvent(selectedUIElements));
		
		for(ISelectable s:this.getSelectedElements().values()){
			
			s.fireEvent(new UnselectEvent());
		}
		
		this.selectedUIElements.clear();		

	}

	//////EVENT HANDLERS 
	
	public void addDropHandler(IDropHandler dropHandler) {
		handlerManager.addHandler(OverEvent.TYPE,(DropHandler) dropHandler);
		handlerManager.addHandler(OutEvent.TYPE,(DropHandler) dropHandler);
		handlerManager.addHandler(DropAcceptedEvent.TYPE,(DropHandler) dropHandler);
		handlerManager.addHandler(DropRefusedEvent.TYPE,(DropHandler) dropHandler);
	}
	
	@Override
	public void addContainerHandler(IContainerHandler handler) {
		handlerManager.addHandler(AddUIElementEvent.TYPE, handler);
		handlerManager.addHandler(RemoveUIElementEvent.TYPE, handler);
	}
	
	public void addUIPanelHandler(IUIPanelHandler handler) {
		handlerManager.addHandler(SelectedElementsEvent.TYPE, handler);
		handlerManager.addHandler(UnselectedElementsEvent.TYPE, handler);
		handlerManager.addHandler(NewUIElementsEvent.TYPE, handler);
		handlerManager.addHandler(RemoveUIElementsEvent.TYPE, handler);
		handlerManager.addHandler(ResizeRequestEvent.TYPE, handler);
	}
	
	
	@Override
	public void removeUIPanelHandler(IUIPanelHandler handler) {
		handlerManager.removeHandler(SelectedElementsEvent.TYPE, handler);
		handlerManager.removeHandler(UnselectedElementsEvent.TYPE, handler);
		handlerManager.removeHandler(NewUIElementsEvent.TYPE, handler);
		handlerManager.removeHandler(RemoveUIElementsEvent.TYPE, handler);
		handlerManager.removeHandler(ResizeRequestEvent.TYPE, handler);
	}
	
	
	@Override
	public IDroppableDefaultHandlers getDroppableDefaultHandlers() {return null;}

	@Override
	public HandlerManager getHandlerManager() {
		return handlerManager;
	}

	@Override
	public String getId() {
		return this.getElement().getId();
	}

	@Override
	public IPoint getNorthWestPoint() {
		return new Point(this.getAbsoluteLeft(),this.getAbsoluteTop());
	}

	@Override
	public IPoint getSouthEastPoint() {
		return new Point(this.getAbsoluteLeft() + this.getWidth(),this.getAbsoluteLeft() + this.getHeight());
	}

	@Override
	public IUIPanel getUIPanel() {
		return null;
	}

	@Override
	public IContainer getContainer() {
		return null;
	}

	@Override
	public float getRelativeX() {return 0;}

	@Override
	public float getRelativeY() {return 0;}

	@Override
	public void setContainer(IContainer container) {}

	@Override
	public void setRelativeX(float x) {}

	@Override
	public void setRelativeY(float y) {}

	@Override
	public void removeAllChildren() {
		
		for(IUIElement el:childrenUIElements.values()){
			removeChildElement(el);
		}
		
	}

	@Override
	public void removeChildElement(IUIElement uiElement) {
		this.childrenUIElements.remove(uiElement.getId());
		this.fireEvent(new RemoveUIElementEvent(uiElement));
	}
	
	@Override
	public void removeElement(IUIElement uiElement) {
		
		//remove from actual elements list
		this.uiElements.remove(uiElement.getId());
		
		//remove from ddManager
		if (uiElement instanceof IDroppableElement) this.getDDManager().removeDroppable((IDroppableElement)uiElement);
		
		
		//if were dealing with a connectable remove each magnets from DDManager
		if (uiElement instanceof IConnectableElement){
			
			IConnectableElement connectable = (IConnectableElement) uiElement;
			
			for(IMagnet m:connectable.getMagnets()){
				
				this.getDDManager().removeDroppable((IDroppableElement)m);
				
			}
			
		}
		
		//if were removing a container remove all its children from current list
		if (uiElement instanceof IContainer){
			IContainer container = (IContainer) uiElement;
			ArrayList<IUIElement> elToRemove = new ArrayList<IUIElement>();
			for(IUIElement child:container.getChildrenUIElements().values()){
								
				elToRemove.add(child);
			}
			
			for(IUIElement child:elToRemove){
				removeElement(child);
			}
			
			elToRemove.clear();
			
		}

		//When removing a connectable => remove connectable reference from 
		//incoming or outgoing connector
		if (uiElement instanceof IConnectableElement){
			IConnectableElement connectable = (IConnectableElement) uiElement;
			
			for(IConnector incomingC:connectable.getIncommingConnectors()){
			
				if (incomingC.getTarget().equals(connectable)) incomingC.setTarget(null);
				
				//find the magnet of connector point of connector and set it to null
				for(IConnectorPoint m:incomingC.getAllConnectorPoints()){
						
					if (m.getConnectedToMagnet()!=null){
						if (m.getConnectedToMagnet().getConnectableElement().equals(connectable)){
							m.setConnectedToMagnet(null);
						}
					}
				
				}
				
			}

			
			for(IConnector outgoingC:connectable.getOutgoingConnectors()){
				
				if (outgoingC.getSource().equals(connectable)) outgoingC.setSource(null);

				//find the magnet of connector point of connector and set it to null
				for(IConnectorPoint m:outgoingC.getAllConnectorPoints()){
						
					if (m.getConnectedToMagnet()!=null){
						if (m.getConnectedToMagnet().getConnectableElement().equals(connectable)){
							m.setConnectedToMagnet(null);
						}
					}
				
				}
				
			}
			
		}
		

		//When removing a connector => remove connector reference from
		//source or target
		if (uiElement instanceof IConnector) {
			
			IConnector connector = (IConnector) uiElement;
			
			if (connector.getSource()!=null) connector.getSource().getOutgoingConnectors().remove(connector);

			if (connector.getTarget()!=null) connector.getTarget().getIncommingConnectors().remove(connector);


			
		}
		
		

		if (uiElement.getContainer() !=null){
			uiElement.getContainer().removeChildElement(uiElement);
		}
		
		
		if (uiElement instanceof UIElement) ((UIElement)uiElement).removeFromParent();
//		System.out.println("UIPanel contains:"+uiElements.size());
//		System.out.println("DDManager contains:"+ddManager.getDroppables().size());
		this.fireEvent(new RemoveUIElementsEvent(uiElement));
		

	}
	
	@Override
	public void removeAllElements() {
		
		ArrayList<IUIElement> elToRemove = new ArrayList<IUIElement>();
		
		for(IUIElement el:uiElements.values()){
			if (el.getContainer()==this) elToRemove.add(el);
		}
		
		for(IUIElement el:elToRemove){
			removeElement(el);
		}
		
		elToRemove.clear();
		
	}
	///////DOM Key handlers
	
	@Override
	public HandlerRegistration addKeyPressHandler(KeyPressHandler handler) {
		return addDomHandler(handler, KeyPressEvent.getType());
	}
	
	
	///////DOM Mouse Handlers
	
	public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
		return addDomHandler(handler, MouseDownEvent.getType());
	}

	public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
		return addDomHandler(handler, MouseUpEvent.getType());
	}

	public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
		return addDomHandler(handler, MouseOutEvent.getType());
	}

	public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
		return addDomHandler(handler, MouseOverEvent.getType());
	}

	public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {
		return addDomHandler(handler, MouseMoveEvent.getType());
	}

	public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {
		return addDomHandler(handler, MouseWheelEvent.getType());
	}

	public HandlerRegistration addClickHandler(ClickHandler handler) {
		return addDomHandler(handler, ClickEvent.getType());
	}

	public HandlerRegistration addDoubleClickHandler(DoubleClickHandler handler) {
		return addDomHandler(handler, DoubleClickEvent.getType());
	}

	@Override
	public HandlerRegistration addScrollHandler(ScrollHandler handler) {
		return addDomHandler(handler, ScrollEvent.getType());
	}
	
	//////Graph stuffs
	
	@Override
	public void addNode(INode node) {
		this.nodes.add(node);
	}

	@Override
	public HashSet<INode> getNodes() {
		return nodes;
	}

	//////Resize Handlers
	public IRegion getTopRegion(){
		return new Region(new Point(getScrollLeft(),getScrollTop()),new Point(getClientWidth()+getScrollLeft(),30+getScrollTop()));
	}
	
	public IRegion getBottomRegion(){
		return new Region(new Point(getScrollLeft(),getScrollTop()+getClientHeight()-30),new Point(getClientWidth()+getScrollLeft(),getClientHeight()+getScrollTop()));		
	}
	
	public IRegion getLeftRegion(){
		return new Region(new Point(getScrollLeft(),getScrollTop()),new Point(30+getScrollLeft(),getClientHeight()+getScrollTop()));	
	}
	
	public IRegion getRightRegion(){
		return new Region(new Point(getClientWidth()-30+getScrollLeft(),getScrollTop()),new Point(getClientWidth()+getScrollLeft(),getClientHeight()+getScrollTop()));
	}
	
	public IUIPanelResizeUIHandler getTopResizeHandler(){
		
		if (this.topResizeHandler==null){
			this.topResizeHandler 		= new DefaultTopResizeUIHandler(this);
		}
		
		return topResizeHandler;
	}
	
	public IUIPanelResizeUIHandler getBottomResizeHandler(){
		
		if (bottomResizeHandler==null){

			this.bottomResizeHandler 	= new DefaultBottomResizeUIHandler(this);

		}
		
		
		return bottomResizeHandler;
	}
	
	public IUIPanelResizeUIHandler getLeftResizeHandler(){

		if (leftResizeHandler ==null){

			this.leftResizeHandler 		= new DefaultLeftResizeUIHandler(this);

		}
		
		return leftResizeHandler;
	}
	
	public IUIPanelResizeUIHandler getRightResizeHandler(){

		if (rightResizeHandler==null){
			
			this.rightResizeHandler 	= new DefaultRightResizeUIHandler(this);
			
		}
		
		return rightResizeHandler;
	}
	
	@Override
	public void refreshUIHandlers() {
		
		
		this.mainPanel.setWidgetPosition((Widget) getTopResizeHandler(),(int)getTopRegion().getNorthWestPoint().getX(),(int)getTopRegion().getNorthWestPoint().getY());
		this.mainPanel.setWidgetPosition((Widget) getBottomResizeHandler(),(int)getBottomRegion().getNorthWestPoint().getX(),(int)getBottomRegion().getNorthWestPoint().getY());
		this.mainPanel.setWidgetPosition((Widget) getLeftResizeHandler(),(int)getLeftRegion().getNorthWestPoint().getX(),(int)getLeftRegion().getNorthWestPoint().getY());
		this.mainPanel.setWidgetPosition((Widget) getRightResizeHandler(),(int)getRightRegion().getNorthWestPoint().getX(),(int)getRightRegion().getNorthWestPoint().getY());
		
		this.getTopResizeHandler().setWidth(getClientWidth());
		this.getTopResizeHandler().setHeight(30);

		this.getBottomResizeHandler().setWidth(getClientWidth());
		this.getBottomResizeHandler().setHeight(30);
		
		this.getRightResizeHandler().setWidth(30);
		this.getRightResizeHandler().setHeight(getClientHeight());
		
		this.getLeftResizeHandler().setWidth(30);
		this.getLeftResizeHandler().setHeight(getClientHeight());
		
	}
	

	
}
