/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.uipanel;

import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.user.client.ui.Image;

public class DefaultLeftResizeUIHandler extends UIPanelResizeUIHandler{

	protected Image increaseBtn;
	protected Image decreaseBtn;
	
	public  DefaultLeftResizeUIHandler(IUIPanel uiPanel) {
		super(uiPanel);
	
		this.setStyleName("uiPanel-left-ResizeBck");

	}
	
	@Override
	public HasClickHandlers getDecreaseBtn() {
		
		if (decreaseBtn==null){
			this.decreaseBtn = new Image(GWT.getModuleBaseURL()+"/images/uipanel/left_decrease.png");
			this.decreaseBtn.setTitle("Click to decrease panel width");
			}
		
		return decreaseBtn;
	}

	@Override
	public HasClickHandlers getIncreaseBtn() {
		
		if (increaseBtn==null){
			this.increaseBtn = new Image(GWT.getModuleBaseURL()+"/images/uipanel/left_increase.png");
			this.increaseBtn.setTitle("Click to increase panel width");
		}
		
		return increaseBtn;
	}

	@Override
	public int getHeight() {
		return this.getUIPanel().getClientHeight();
	}

	@Override
	public int getWidth() {
		return 30;
	}

	@Override
	public void refresh() {
		this.setPixelSize(getWidth(), getHeight());
		
		//set btns position
		int panelHeightMiddle = getHeight()/2;
		this.getMainPanel().setWidgetPosition(increaseBtn, 4, panelHeightMiddle-23);
		this.getMainPanel().setWidgetPosition(decreaseBtn, 4, panelHeightMiddle+23);
		
	}
	
	@Override
	public void hideDecreaseBtn() {
		this.decreaseBtn.setVisible(false);
	}

	@Override
	public void hideIncreaseBtn() {
		this.increaseBtn.setVisible(false);
	}

	@Override
	public void showDecreaseBtn() {
		this.decreaseBtn.setVisible(true);
	}

	@Override
	public void showIncreaseBtn() {
		this.increaseBtn.setVisible(true);
	}
	
}
