/**
 * webeditor-domain - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webeditor.api.domain.project;

import java.util.Date;
import java.util.HashSet;
import java.util.List;

import com.ebmwebsourcing.webeditor.api.domain.user.IUser;
import com.google.gwt.user.client.rpc.IsSerializable;


public interface IProjectInstance extends IsSerializable{

	IProjectType getProjectType();
	
	String getId();
	
	String getName();
	
	boolean isPublic();
	
	boolean isAutoSave();
	
	IUser getAuthor();
	
	Date getCreationDate();
	
	Date getLastModificationDate();
	
	void setLastModificationDate(Date lastModifDate);
	
	HashSet<IProjectGroup> getProjectGroups();
	
	IProjectInstanceMetaData getExportData();
	
	IProjectInstanceMetaData getImportData();
	
	void setType(IProjectType type);
	
	void setAuthor(IUser author);
	
	void setId(String id);
	
	void setName(String name);
	
	List<IProjectInstanceMetaData> getMetaDatas();
	
	void addMetadata(IProjectInstanceMetaData metaData);
	
	void setPublic(boolean ispublic);
	
	void setAutoSave(boolean autosave);
	
	void bind(IProjectConfigurationData data);
	
}
