/**
 * webeditor-domain - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.webeditor.impl.domain.project;

import java.util.Date;

import com.ebmwebsourcing.webeditor.api.domain.project.IProjectFile;

public class ProjectFile implements IProjectFile {

	private String projectInstanceId;
	private String name;
	private Date creationDate;
	private Date lastModificationDate;
	
	private ProjectFile() {
		super();
	}

	public ProjectFile(String projectInstanceId, String name,
			Date creationDate, Date lastModificationDate) {
		this();
		this.projectInstanceId = projectInstanceId;
		this.name = name;
		this.creationDate = creationDate;
		this.lastModificationDate = lastModificationDate;
	}

	@Override
	public String getProjectInstanceId() {
		return projectInstanceId;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public Date getCreationDate() {
		return creationDate;
	}

	@Override
	public Date getLastModificationDate() {
		return lastModificationDate;
	}

}
