/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter;

import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IImportProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.events.IImportProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.events.IProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.events.IProjectConfigurationHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter.AbstractCommonPresentersTest;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter.ImportProjectPresenter;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFolderSelectedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.IFinishEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.file.event.FolderSelectedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.wizard.event.FinishEvent;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.google.gwt.event.logical.shared.PublicValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.HasValue;
import gwtupload.client.IUploader;
import java.util.List;
import junit.framework.Assert;
import net.customware.gwt.presenter.client.place.PlaceParsingException;
import net.customware.gwt.presenter.client.place.PlaceRequest;
import net.customware.gwt.presenter.client.place.PlaceRequestEvent;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Before;
import org.junit.Test;

public class ImportProjectPresenterTest
extends AbstractCommonPresentersTest {
    private IImportProjectConfigurationView displayMock;
    private IUploader uploaderMock;
    private IUploader.OnFinishUploaderHandler finishUploaderHandler;
    private ImportProjectPresenter presenter;
    private HasValue<String> importFormatDescriptionMock;
    private String UPLOAD_INPUT_NAME = "myUPLOAD";
    private boolean configurationCompleteCalled = false;

    @Before
    public void iniMocksAndExpectations() {
        this.displayMock = (IImportProjectConfigurationView)EasyMock.createMock(IImportProjectConfigurationView.class);
        this.importFormatDescriptionMock = (HasValue)EasyMock.createMock(HasValue.class);
        this.uploaderMock = (IUploader)EasyMock.createMock(IUploader.class);
        EasyMock.expect((Object)this.displayMock.getFolderPanel()).andReturn((Object)this.folderPanelMock);
        EasyMock.expect((Object)this.displayMock.getImportFormat()).andReturn((Object)this.comboboxMock).anyTimes();
        EasyMock.expect((Object)this.displayMock.getUploader()).andReturn((Object)this.uploaderMock);
        EasyMock.expect((Object)this.displayMock.getWizard()).andReturn((Object)this.wizardMock);
        EasyMock.expect((Object)this.displayMock.getImportFormatDescription()).andReturn(this.importFormatDescriptionMock).anyTimes();
        this.displayMock.setAvailableProjectTypes((List)this.projectTypes);
        EasyMock.replay((Object[])new Object[]{this.displayMock});
        EasyMock.expect((Object)this.uploaderMock.addOnFinishUploadHandler((IUploader.OnFinishUploaderHandler)EasyMock.isA(IUploader.OnFinishUploaderHandler.class)));
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                Object[] params = EasyMock.getCurrentArguments();
                ImportProjectPresenterTest.this.finishUploaderHandler = (IUploader.OnFinishUploaderHandler)params[0];
                return null;
            }
        });
        EasyMock.expect((Object)this.uploaderMock.getInputName()).andReturn((Object)this.UPLOAD_INPUT_NAME);
        this.uploaderMock.submit();
        EasyMock.replay((Object[])new Object[]{this.uploaderMock});
        this.presenter = new ImportProjectPresenter(this.displayMock, this.eventBus);
        this.presenter.bind();
        this.importFormatDescriptionMock.setValue(EasyMock.isA(String.class));
        EasyMock.expect((Object)this.importFormatDescriptionMock.getValue()).andReturn((Object)((IProjectInstanceFormat)this.importFormats.get(0)).getDescription());
        EasyMock.replay((Object[])new Object[]{this.importFormatDescriptionMock});
    }

    @Test
    public void testHasAvailableProjectTypesOnLoad_AndDisplaysOnView() {
        Assert.assertEquals((Object)this.projectTypes, (Object)this.presenter.getAvailableProjectTypes());
    }

    @Test
    public void testNoImportFormatAvailableOnLoad() {
        Assert.assertEquals(null, (Object)this.presenter.getCurrentImportFormats());
    }

    @Test
    public void testRequestOnPlaceOpensDisplay() throws PlaceParsingException {
        EasyMock.reset((Object[])new Object[]{this.displayMock});
        this.displayMock.open();
        this.displayMock.setAvailableProjectTypes((List)this.projectTypes);
        EasyMock.replay((Object[])new Object[]{this.displayMock});
        String req = ImportProjectPresenter.PLACE.getId();
        this.eventBus.fireEvent((GwtEvent)new PlaceRequestEvent(PlaceRequest.fromString((String)req)));
        EasyMock.verify((Object[])new Object[]{this.displayMock});
    }

    @Test
    public void testProjectTypeSelection_DisplaysImportFormats() {
        this.folderPanelHandler.onFolderSelected((IFolderSelectedEvent)new FolderSelectedEvent(this.folderMock));
        Assert.assertTrue((this.presenter.getCurrentImportFormats().size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)this.presenter.getSelectedProjectType());
    }

    @Test
    public void testOnImportFormatChange_FormatDescriptionChangeOnView() {
        Assert.assertNull((Object)this.presenter.getSelectedImportFormat());
        this.folderPanelHandler.onFolderSelected((IFolderSelectedEvent)new FolderSelectedEvent(this.folderMock));
        this.comboboxValueChangeHandler.onValueChange((ValueChangeEvent)new PublicValueChangeEvent(this.importFormats.get(0)));
        Assert.assertNotNull((Object)this.presenter.getSelectedImportFormat());
        Assert.assertNotNull((Object)this.importFormatDescriptionMock.getValue());
        EasyMock.verify((Object[])new Object[]{this.importFormatDescriptionMock});
    }

    @Test
    public void testImportFormatSelection_AndClickOnFinish_FiresImportProjectConfigurationCompleteEvent_WitParamsNotNull() {
        this.folderPanelHandler.onFolderSelected((IFolderSelectedEvent)new FolderSelectedEvent(this.folderMock));
        this.comboboxValueChangeHandler.onValueChange((ValueChangeEvent)new PublicValueChangeEvent(this.importFormats.get(0)));
        EasyMock.reset((Object[])new Object[]{this.displayMock});
        EasyMock.expect((Object)this.displayMock.getUploader()).andReturn((Object)this.uploaderMock);
        this.displayMock.refresh();
        this.displayMock.close();
        EasyMock.replay((Object[])new Object[]{this.displayMock});
        this.finishUploaderHandler.onFinish(this.uploaderMock);
        this.eventBus.addProjectConfigurationHandler(new IProjectConfigurationHandler(){

            public void onConfigurationComplete(IProjectConfigurationCompleteEvent event) {
                if (event instanceof IImportProjectConfigurationCompleteEvent) {
                    IImportProjectConfigurationCompleteEvent e = (IImportProjectConfigurationCompleteEvent)event;
                    Assert.assertEquals((Object)ImportProjectPresenterTest.this.presenter.getSelectedProjectType(), (Object)e.getProjectType());
                    Assert.assertEquals((Object)ImportProjectPresenterTest.this.presenter.getSelectedImportFormat(), (Object)e.getFormat());
                    Assert.assertEquals((String)ImportProjectPresenterTest.this.UPLOAD_INPUT_NAME, (String)e.getUploadRef());
                    ImportProjectPresenterTest.this.configurationCompleteCalled = true;
                }
            }
        });
        this.wizardHandler.onFinish((IFinishEvent)new FinishEvent());
    }
}

