/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.webeditor.server.impl.service.project;

import com.ebmwebsourcing.webeditor.api.domain.project.IProjectFile;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.api.domain.user.IUser;
import com.ebmwebsourcing.webeditor.client.impl.service.project.PropertyFileFormat;
import com.ebmwebsourcing.webeditor.client.impl.service.project.PropertyFileProjectInstance;
import com.ebmwebsourcing.webeditor.impl.domain.exception.ServiceException;
import com.ebmwebsourcing.webeditor.impl.domain.user.User;
import com.ebmwebsourcing.webeditor.server.impl.service.common.AbstractCommonServiceTest;
import com.ebmwebsourcing.webeditor.server.impl.service.download.DownloadService;
import com.ebmwebsourcing.webeditor.server.impl.service.project.ImportProjectTestServlet;
import com.ebmwebsourcing.webeditor.server.impl.service.project.ProjectServiceImpl;
import com.ebmwebsourcing.webeditor.server.impl.service.upload.UploadClient;
import com.ebmwebsourcing.webeditor.server.impl.service.user.UserServiceImpl;
import com.ebmwebsourcing.webeditor.server.impl.service.webeditor.WebEditorService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.servlet.Servlet;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProjectServiceImplTest
extends AbstractCommonServiceTest {
    private static String IMPORT_SERVLET_PATH_SPEC = "/importProjectTest";
    protected List<IProjectInstance> projectInstances;
    protected List<IProjectFile> projectFiles;

    @BeforeClass
    public static void preInit() throws IOException {
        File webEditor = new File(WebEditorService.WEB_EDITOR_BASE_PATH);
        if (webEditor.exists()) {
            FileUtils.deleteDirectory((File)webEditor);
        }
    }

    @Before
    public void init() throws IOException {
        WebEditorService.getInstance();
        PropertyFileProjectInstance pi = new PropertyFileProjectInstance();
        User user = new User();
        user.setLogin("user1");
        user.setId("user1ID");
        pi.setAuthor((IUser)user);
        pi.setId(String.valueOf(System.currentTimeMillis()));
    }

    @Test
    public void testSaveProjectInstance() throws ServiceException, FileNotFoundException, IOException {
        WebEditorService.getInstance();
        ProjectServiceImpl projectService = ProjectServiceImpl.getInstance();
        String fileContent = "fileContent";
        PropertyFileProjectInstance pfi1 = new PropertyFileProjectInstance();
        pfi1.setName("pf1");
        pfi1.setId("pf1ID");
        pfi1.setContent(fileContent);
        Date beforeSave = pfi1.getLastModificationDate();
        projectService.saveProjectInstance((IProjectInstance)pfi1);
        Assert.assertTrue((beforeSave.before(pfi1.getLastModificationDate()) || beforeSave.equals(pfi1.getLastModificationDate()) ? 1 : 0) != 0);
    }

    @Test
    public void testImportProjectInstance() throws Exception {
        WebEditorService.getInstance();
        UploadClient uploadClient = new UploadClient();
        uploadClient.startServletTester();
        Servlet importServlet = uploadClient.addServlet(ImportProjectTestServlet.class, IMPORT_SERVLET_PATH_SPEC);
        uploadClient.uploadFile(new File(this.getActualPath() + "file1.properties"));
        HttpGet httpget = new HttpGet(uploadClient.getBaseUrl() + IMPORT_SERVLET_PATH_SPEC);
        HttpResponse response = uploadClient.getHttpclient().execute((HttpUriRequest)httpget);
        StatusLine statusLine = response.getStatusLine();
        Assert.assertEquals((int)200, (int)statusLine.getStatusCode());
        EntityUtils.consume((HttpEntity)response.getEntity());
        List instances = (List)importServlet.getServletConfig().getServletContext().getAttribute("projectInstances");
        PropertyFileProjectInstance pfpi = (PropertyFileProjectInstance)instances.get(0);
        Assert.assertEquals((String)"file1content", (String)pfpi.getContent());
        uploadClient.shutDownHttpClient();
        uploadClient.stopServletTester();
    }

    @Test
    public void testExportProjectInstance() throws ServiceException, FileNotFoundException, IOException {
        WebEditorService.getInstance();
        String fileContent = "fileContent";
        PropertyFileProjectInstance pfi1 = new PropertyFileProjectInstance();
        pfi1.setName("pf1");
        pfi1.setId("pf1ID");
        pfi1.setContent(fileContent);
        String id1 = ProjectServiceImpl.getInstance().exportProjectInstance((IProjectInstance)pfi1, (IProjectInstanceFormat)PropertyFileFormat.PROPERTIES);
        File f1 = DownloadService.getInstance().getFileToDownload(id1);
        Assert.assertNotNull((Object)f1);
        Assert.assertTrue((boolean)f1.exists());
        File directory = WebEditorService.getInstance().getTemporaryUploadFolderDirectory(UserServiceImpl.getInstance().getLoggedUser(), pfi1.getProjectType());
        File assumedFile = new File(directory, f1.getName());
        Assert.assertEquals((String)assumedFile.getAbsolutePath(), (String)f1.getAbsolutePath());
        Properties p = new Properties();
        p.load(new FileInputStream(f1));
        String content = p.getProperty("content");
        Assert.assertEquals((String)fileContent, (String)content);
        String id2 = ProjectServiceImpl.getInstance().exportProjectInstance((IProjectInstance)pfi1, (IProjectInstanceFormat)PropertyFileFormat.TXT);
        Assert.assertNotNull((Object)DownloadService.getInstance().getFileToDownload(id2));
    }
}

