/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.webeditor.server.impl.service.webeditor;

import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;
import com.ebmwebsourcing.webeditor.api.domain.user.IUser;
import com.ebmwebsourcing.webeditor.client.impl.service.project.PropertyFileProjectInstance;
import com.ebmwebsourcing.webeditor.impl.domain.project.ProjectType;
import com.ebmwebsourcing.webeditor.impl.domain.user.User;
import com.ebmwebsourcing.webeditor.server.impl.service.common.AbstractCommonServiceTest;
import com.ebmwebsourcing.webeditor.server.impl.service.webeditor.WebEditorService;
import java.io.File;
import junit.framework.Assert;
import org.junit.Test;

public class WebEditorServiceTest
extends AbstractCommonServiceTest {
    @Test
    public void testGetProjectsDirectory() {
        WebEditorService service = WebEditorService.getInstance();
        File file = service.getProjectsDirectory();
        Assert.assertEquals((String)this.projectsDir, (String)file.toString());
        Assert.assertTrue((boolean)file.exists());
    }

    @Test
    public void testGetProjectDirectoryWithUserAndProjectInstance() {
        WebEditorService service = WebEditorService.getInstance();
        User user = new User();
        user.setId("userID");
        ProjectType projectType = new ProjectType();
        projectType.setId("projectTypeID");
        PropertyFileProjectInstance instance = new PropertyFileProjectInstance();
        instance.setType((IProjectType)projectType);
        instance.setId("instanceID");
        File file = service.getProjectDirectory((IUser)user, (IProjectInstance)instance);
        Assert.assertEquals((String)(this.projectsDir + File.separator + user.getId() + File.separator + projectType.getId() + File.separator + instance.getId()), (String)file.toString());
        Assert.assertTrue((boolean)file.exists());
    }

    @Test
    public void testGetTemporaryProjectDirectoryWithUserAndProjectType() {
        WebEditorService service = WebEditorService.getInstance();
        User user = new User();
        user.setId("userID");
        ProjectType projectType = new ProjectType();
        projectType.setId("projectTypeID");
        File file = service.getTemporaryUploadFolderDirectory((IUser)user, (IProjectType)projectType);
        String tmpDir = null;
        if (WebEditorServiceTest.isWindows() || WebEditorServiceTest.isMac()) {
            tmpDir = System.getProperty("java.io.tmpdir") + user.getId() + File.separator + projectType.getId();
        }
        if (WebEditorServiceTest.isUnix()) {
            tmpDir = System.getProperty("java.io.tmpdir") + File.separator + user.getId() + File.separator + projectType.getId();
        }
        Assert.assertEquals(tmpDir, (String)file.toString());
        Assert.assertTrue((boolean)file.exists());
    }
}

