/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.webeditor.server.impl.service.project;

import com.ebmwebsourcing.webeditor.api.domain.project.IProjectFile;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.impl.domain.exception.ServiceException;
import com.ebmwebsourcing.webeditor.server.impl.service.project.ProjectServiceHelper;
import com.ebmwebsourcing.webeditor.server.impl.service.project.PropertyFileProjectInstance;
import com.ebmwebsourcing.webeditor.shared.server.api.service.project.IProjectInstanceLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class PropertyFileProjectInstanceLoader
implements IProjectInstanceLoader {
    public List<IProjectInstance> getProjectInstances(List<File> projectFiles, IProjectInstanceFormat projectFilesFormat) {
        ArrayList<IProjectInstance> result = new ArrayList<IProjectInstance>();
        for (int i = 0; i < projectFiles.size(); ++i) {
            PropertyFileProjectInstance pi = this.getInstance(projectFiles.get(i), null);
            result.add(i, pi);
        }
        return result;
    }

    private PropertyFileProjectInstance getInstance(File file, PropertyFileProjectInstance propertyFileProjectInstance) {
        try {
            Properties p = new Properties();
            p.load(new FileInputStream(file));
            if (propertyFileProjectInstance == null) {
                propertyFileProjectInstance = new PropertyFileProjectInstance();
            }
            propertyFileProjectInstance.setContent(p.getProperty("content"));
            return propertyFileProjectInstance;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<IProjectInstance> getProjectInstances(List<IProjectInstance> instances) throws ServiceException {
        ArrayList<IProjectInstance> result = new ArrayList<IProjectInstance>();
        for (IProjectInstance pi : instances) {
            this.getInstance(ProjectServiceHelper.convert((IProjectFile)pi.getFile()), (PropertyFileProjectInstance)pi);
            result.add(pi);
        }
        return result;
    }
}

