/**
 * webeditor-service - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webeditor.server.impl.service.download;

import java.io.File;
import java.util.HashMap;

public class DownloadService {

	private static DownloadService instance;
	
	private HashMap<String,File> filesToDownload;
	
	private DownloadService(){
		
		this.filesToDownload = new HashMap<String, File>();
		
	}
	
	
	public static DownloadService getInstance(){
		
		if (instance==null){
			instance = new DownloadService();
		}
		
		return instance;
	}
	
	
	public void registerFileToDownload(String id,File file){
		this.filesToDownload.put(id, file);
	}
	
	
	public File getFileToDownload(String id){
		return this.filesToDownload.get(id);
	}
	
	public HashMap<String, File> getFilesToDownload() {
		return filesToDownload;
	}
	
	
}
