/**
 * webeditor-service - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


package com.ebmwebsourcing.webeditor.server.impl.service.download;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;

import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Helper servlet that downloads any URL specified as a parameter
 * @author nfleury
 *
 */
public class DownloadServlet extends HttpServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private int BUFSIZE = 1024;
	
	
	
	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {

		
		try {
			execute(req, resp);
		} catch (Exception e) {

			e.printStackTrace();
		}
		
		super.doPost(req, resp);
	}
	
	
	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {

		
		try {
			execute(req, resp);
		} catch (Exception e) {

			e.printStackTrace();
		}
		
		
	}
	
	
	private void execute( HttpServletRequest req, HttpServletResponse resp)
    throws IOException, URISyntaxException{
		

		
		doDownload(req, resp);
		
	}
	
	
	
	  /**
     *  Sends a file to the ServletResponse output stream.  Typically
     *  you want the browser to receive a different name than the
     *  name the file has been saved in your local database, since
     *  your local names need to be unique.
     *
     *  @param req The request
     *  @param resp The response
     *  @param filename The name of the file you want to download.
     *  @param original_filename The name the browser should receive.
	 * @throws URISyntaxException 
     */
    private void doDownload( HttpServletRequest req, HttpServletResponse resp)
        throws IOException, URISyntaxException
    {

    	String fileID = req.getParameter("fileID");
        
        File fileToDownload = DownloadService.getInstance().getFileToDownload(fileID);
        
        fileToDownload.exists();
        
        int contentLength = (int) fileToDownload.length();
        
        String mimetype= new MimetypesFileTypeMap().getContentType(fileToDownload);
        
        FileInputStream fis = new FileInputStream(fileToDownload);
        
      
	    
        //
        //  Set the response and go!
        //
        //
        resp.setContentType( (mimetype != null) ? mimetype : "application/octet-stream" );
        resp.setContentLength( (int)contentLength );
        resp.setHeader( "Content-Disposition", "attachment; filename=\"" + fileToDownload.getName() + "\"" );

        //
        //  Stream to the requester.
        //

        InputStream in = new BufferedInputStream(fis);
        byte[] data = new byte[contentLength];
        int bytesRead = 0;
        int offset = 0;
        while (offset < contentLength) {
          bytesRead = in.read(data, offset, data.length - offset);
          if (bytesRead == -1)
            break;
          offset += bytesRead;
        }
        in.close();
        
        
        if (offset != contentLength) {
            throw new IOException("Only read " + offset + " bytes; Expected " + contentLength + " bytes");
          }

        ServletOutputStream op       = resp.getOutputStream();
        op.write(data);
        op.flush();
        op.close();
    }

}
