/**
 * webeditor-service - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webeditor.server.impl.service.project;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.webeditor.api.domain.project.IProjectFile;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.impl.domain.project.ProjectFile;

public class ProjectServiceHelper {

	
	public static File convert(IProjectFile projectFile){
		
		File f = new File(projectFile.getAbsolutePath());
		
		if (f.isDirectory()) f = new File(projectFile.getAbsolutePath()+File.separator+projectFile.getName());
		
		return f;
	}
	
	public static List<IProjectInstance> retrieveProjectInstances(List<IProjectFile> projectFiles){
		
		List<IProjectInstance> result = new ArrayList<IProjectInstance>();
		
		for(IProjectFile f:projectFiles){
			result.add(f.getProjectInstance());
		}
		
		
		return result;
	}
	
	
	public static List<File> convert(List<IProjectFile> projectFiles){
		
		List<File> files = new ArrayList<File>();
		
		for(int i=0;i<projectFiles.size();i++){
			
			File f = convert(projectFiles.get(i));
			
			files.add(i, f);
			
		}
		
		return files;
	}
	
	public static IProjectFile convert(File file){
		
		ProjectFile pf = new ProjectFile();
		
		pf.setAbsolutePath(file.getAbsolutePath());
		pf.setName(file.getName());
		
		return pf;
	}
	
}
