/**
 * webeditor-service - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webeditor.server.impl.service.upload;

import gwtupload.server.UploadServlet;

import java.io.File;
import java.util.HashMap;
import java.util.Vector;

import javax.servlet.http.HttpSession;

import org.apache.commons.fileupload.FileItem;

import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;
import com.ebmwebsourcing.webeditor.api.domain.user.IUser;
import com.ebmwebsourcing.webeditor.impl.domain.exception.ServiceException;
import com.ebmwebsourcing.webeditor.server.impl.service.webeditor.WebEditorService;

/**
 * Info: Temporary Singleton class until Spring dependency injection is implemented 
 * 
 * @author nfleury
 *
 */
public class UploadService {
	
	private static UploadService instance;
	
	private WebEditorService webEditorService = WebEditorService.getInstance();
	
	private HashMap<String,File> registeredFiles;
	
	private static HttpSession session;
	
	private UploadService(HttpSession session){
		this.session = session;
		this.registeredFiles = new HashMap<String, File>();
	}
	
	
	public static UploadService getInstance(HttpSession session){
		if (UploadService.session!=session) UploadService.session = session;
		if (instance==null){
			instance = new UploadService(session);
		}
		
		return instance;
	}
	
	public void registerFile(String key,File file){
	    //FIXME memory leak : this map is never emptied
		registeredFiles.put(key, file);
	}


	@SuppressWarnings("unchecked")
	public File getUploadedFileFromSession(String key,IUser user,IProjectType projectType) throws ServiceException{
	
		
		Vector<FileItem> sessionFiles 	= (Vector<FileItem>) session.getAttribute("FILES");
		 
		FileItem fileItem 				= UploadServlet.findFileItem(sessionFiles, key);
		
		//if not found in uploaded file, it may have been registered
		if (fileItem==null){
			File file = this.registeredFiles.get(key);
			
			if (file==null){
				throw new ServiceException("Could not retrieve file with key: "+key);
			}
			
			return file;
		}
		
		File tmpUploadFileDirectory  	= webEditorService.getTemporaryUploadFolderDirectory(user,projectType);
		
		File tmpUploadedFile = new File(tmpUploadFileDirectory.getAbsolutePath()+File.separator+fileItem.getName());
		
		try {
		
			fileItem.write(tmpUploadedFile);
		
		} catch (Exception e) {
			
			throw new ServiceException(e.getMessage());
			
		}
		
		
		return tmpUploadedFile;
	}
	
	
}
