/**
 * webeditor-service - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webeditor.server.impl.service.webeditor;

import java.io.File;
import java.util.Properties;

import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;
import com.ebmwebsourcing.webeditor.api.domain.user.IUser;
import com.ebmwebsourcing.webeditor.impl.xstream.ProjectDao;
import com.ebmwebsourcing.webeditor.impl.xstream.ProjectTypeDao;
import com.ebmwebsourcing.webeditor.impl.xstream.UserDao;

public class WebEditorService {
	
	private static WebEditorService instance;
	
	public final static String WEBEDITOR_CONFIG_PATH	=	"WEBEDITOR_CONFIG_PATH";
	public static String CONFIGURATION_FILE_NAME 		= 	"webeditor.configuration.properties";
	
	public static String WEB_EDITOR_BASE_PATH  = System.getProperty("user.home")+File.separator+".webeditor";
	public static String WEB_EDITOR_FILES_PATH = WEB_EDITOR_BASE_PATH + File.separator+"files";
	
	public static String ATTACHMENTS_DIR = "attachments";
	
	public static boolean TEST_ENV = false;
	
	private Properties properties;
	
	private WebEditorService(){
		
		if (TEST_ENV==true){
			
			if (isUnix()){
				WEB_EDITOR_BASE_PATH 		= System.getProperty("java.io.tmpdir")+File.separator+".webeditor";
				WEB_EDITOR_FILES_PATH 		= WEB_EDITOR_BASE_PATH + File.separator+"files";
				UserDao.BASE_PATH 			= System.getProperty("java.io.tmpdir")+File.separator+".webeditor"+File.separator+"data";
				ProjectDao.BASE_PATH 		= System.getProperty("java.io.tmpdir")+File.separator+".webeditor"+File.separator+"data";
				ProjectTypeDao.BASE_PATH 	= System.getProperty("java.io.tmpdir")+File.separator+".webeditor"+File.separator+"data"; 
			}else{
				WEB_EDITOR_BASE_PATH 		= System.getProperty("java.io.tmpdir")+".webeditor";
				WEB_EDITOR_FILES_PATH 		= WEB_EDITOR_BASE_PATH + File.separator+"files";
				UserDao.BASE_PATH 			= System.getProperty("java.io.tmpdir")+".webeditor"+File.separator+"data";
				ProjectDao.BASE_PATH 		= System.getProperty("java.io.tmpdir")+".webeditor"+File.separator+"data";
				ProjectTypeDao.BASE_PATH 	= System.getProperty("java.io.tmpdir")+".webeditor"+File.separator+"data";				
			}
			
			
		}
		
	}
	
	
	
	
	public static WebEditorService getInstance(){
		
		if (instance==null){
			instance = new WebEditorService();
		}
		
		return instance;
	}
	

	
	
	public File getTemporaryUploadFolderDirectory(IUser user,IProjectType projectType){
		
		File projectDirectory = new File(System.getProperty("java.io.tmpdir")+File.separator+user.getId()+File.separator+projectType.getId());
		
		//ensure that directory exists
		if (projectDirectory.exists()==false){
			projectDirectory.mkdirs();
		}
		
		return projectDirectory;
	}


	
	
	
	public File getProjectsDirectory(){
		
		File projectDirectory = new File(WEB_EDITOR_FILES_PATH); 
		
		//ensure that directory exists
		if (projectDirectory.exists()==false){
			projectDirectory.mkdirs();
		}
		
		return projectDirectory;
	}
	
	
	public File getProjectDirectory(IUser user,IProjectInstance instance){
		
		File projectDirectory = new File(getProjectsDirectory().getAbsolutePath()+File.separator+user.getId()+File.separator+instance.getProjectType().getId()+File.separator+instance.getId());
		
		//ensure that directory exists
		if (projectDirectory.exists()==false){
			projectDirectory.mkdirs();
		}		
		
		return projectDirectory;
	}
	
	public File getAttachedFilesDirectory(IUser user,IProjectInstance instance){
		
		File projectDirectory = this.getProjectDirectory(user, instance);
		
		File attachedFilesDirectory = new File(projectDirectory.getAbsolutePath()+File.separator+ATTACHMENTS_DIR);
		
		if (attachedFilesDirectory.exists()==false){
			attachedFilesDirectory.mkdirs();
		}
		
		return attachedFilesDirectory; 
	}
	
	public Properties getConfigurationProperties() {
		return properties;
	}
	
	private static boolean isWindows(){
		 
		String os = System.getProperty("os.name").toLowerCase();
		//windows
	    return (os.indexOf( "win" ) >= 0); 
 
	}
 
	private static boolean isMac(){
 
		String os = System.getProperty("os.name").toLowerCase();
		//Mac
	    return (os.indexOf( "mac" ) >= 0); 
 
	}
 
	private static boolean isUnix(){
 
		String os = System.getProperty("os.name").toLowerCase();
		//linux or unix
	    return (os.indexOf( "nix") >=0 || os.indexOf( "nux") >=0);
 
	}

	
}
