/**
 * webeditor-service - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webeditor.shared.server.api.service.project;

import java.io.File;
import java.util.List;

import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.impl.domain.exception.ServiceException;

public interface IProjectInstanceLoader {
	
	/**
	 * Used for loading new project instance with no project instance reference, typically for import
	 * @param projectFiles
	 * @param projectFilesFormat
	 * @return
	 * @throws ServiceException
	 */
	List<IProjectInstance> getProjectInstances(List<File> projectFiles,IProjectInstanceFormat projectFilesFormat) throws ServiceException;
	
	/**
	 * Used for loading already stored project instances, typically for load
	 * @param instances
	 * @return
	 * @throws ServiceException
	 */
	List<IProjectInstance> getProjectInstances(List<IProjectInstance> instances) throws ServiceException;
	
}
