/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.addressing.definition.test;

import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.SchemaException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.w3c.dom.Document;

public class WSAddressingDescriptorTest
extends TestCase {
    private String TARGET_NAMESPACE = "http://petals.ow2.org/";

    public QName cName(String string) {
        return new QName(this.TARGET_NAMESPACE, string);
    }

    public WSAddressingDescriptorTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testReaderAddressing() throws URISyntaxException, WSAddressingException {
        EndpointReferenceType endpointReferenceType = WSAddressingFactory.getInstance().newWSAddressingReader().readEndpointReferenceType(new URI("./src/test/resources/descriptors/endpoint.xml"));
        Assert.assertNotNull((Object)endpointReferenceType);
        Assert.assertEquals((String)"testEndpoint", (String)endpointReferenceType.getAddress());
        Assert.assertEquals((int)1, (int)endpointReferenceType.getPolicies().size());
        System.out.println(endpointReferenceType);
        System.out.println(endpointReferenceType.getAddress());
        System.out.println(endpointReferenceType.getPolicies().size());
    }

    public void testWriterAddressing() throws SchemaException, URISyntaxException, SchemaException {
        EndpointReferenceType endpointReferenceType = WSAddressingFactory.getInstance().newWSAddressingReader().readEndpointReferenceType(new URI("./src/test/resources/descriptors/endpoint.xml"));
        String string = WSAddressingFactory.getInstance().newWSAddressingWriter().writeEndpointReferenceType(endpointReferenceType);
        Assert.assertNotNull((Object)string);
        System.out.println("xml plat:\n" + string);
        Document document = WSAddressingFactory.getInstance().newWSAddressingWriter().getDocument(endpointReferenceType);
        Assert.assertNotNull((Object)document);
    }

    public void testCreateAddressing() throws URISyntaxException, SchemaException {
        EndpointReferenceType endpointReferenceType = WSAddressingFactory.getInstance().newEndpointReferenceType();
        endpointReferenceType.setTagQName(new QName("http://petals.ow2.org", "MyEndpoint"));
        endpointReferenceType.setAddress("myEndpointAddress");
        Assert.assertNotNull((Object)endpointReferenceType);
        Document document = WSAddressingFactory.getInstance().newWSAddressingWriter().getDocument(endpointReferenceType);
        Assert.assertNotNull((Object)document);
    }

    public void testPersistAndRestoreEndpointReference() {
        try {
            File[] fileArray;
            String string = "tmp" + File.separatorChar;
            String string2 = string + "SaveEndpointReference" + File.separatorChar;
            File file = new File(string2);
            file.mkdirs();
            EndpointReferenceType endpointReferenceType = WSAddressingFactory.getInstance().newWSAddressingReader().readEndpointReferenceType(new URI("./src/test/resources/descriptors/EndpointReference.xml"));
            File file2 = new File(string2 + UUID.randomUUID().toString());
            WSAddressingFactory.getInstance().newWSAddressingWriter().writeEndpointReferenceType(endpointReferenceType, file2);
            if (file.exists() && file.isDirectory()) {
                fileArray = file.listFiles();
                Object object = null;
                System.out.println(" ########### List of restored Endpoint : ###########");
                for (int i = 0; i < fileArray.length; ++i) {
                    EndpointReferenceType endpointReferenceType2 = WSAddressingFactory.getInstance().newWSAddressingReader().readEndpointReferenceType(fileArray[i]);
                    Document document = WSAddressingFactory.getInstance().newWSAddressingWriter().getDocument(endpointReferenceType2);
                }
                System.out.println(" ########### Fin de List  ###########");
            }
            for (File file3 : fileArray = file.listFiles()) {
                file3.delete();
            }
            file.delete();
            new File(string).delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

