/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.wsstar.addressing.definition.impl;

import javax.xml.namespace.QName;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class Constants {

    /**
     * SchemaImpl Namespace
     */
    public static final String WSADDRESSING_NAMESPACE = "http://www.w3.org/2005/08/addressing";
    
    public static final String WSADDRESSING_PREFIX = "wsa";
    
    /**
     * SchemaImpl root tag
     */
    public static final String ENDPOINT_ROOT_TAG = "endpoint";
    
    public static final String ENDPOINT_REFERENCE_NAME = "EndpointReference";        
    
    public static final QName ENDPOINT_REFERENCE_QNAME = new QName(WSADDRESSING_NAMESPACE,ENDPOINT_REFERENCE_NAME);


    //public static final String NAMESPACE_URI = "http://www.w3.org/2005/08/addressing";

    //public static final String PREFIX = "wsa";

    public static final QName REPLY_TO_QNAME = new QName(WSADDRESSING_NAMESPACE, "ReplyTo", WSADDRESSING_PREFIX);

    public static final QName ADDRESS_QNAME = new QName(WSADDRESSING_NAMESPACE, "Address", WSADDRESSING_PREFIX);

    public static final QName SERVICE_NAME_QNAME = new QName(WSADDRESSING_NAMESPACE, "ServiceName",
    		WSADDRESSING_PREFIX);

    public static final QName FROM_QNAME = new QName(WSADDRESSING_NAMESPACE, "From", WSADDRESSING_PREFIX);

    public static final QName TO_QNAME = new QName(WSADDRESSING_NAMESPACE, "To", WSADDRESSING_PREFIX);

    public static final QName FAULT_TO_QNAME = new QName(WSADDRESSING_NAMESPACE, "FaultTo", WSADDRESSING_PREFIX);

    public static final QName ACTION_QNAME = new QName(WSADDRESSING_NAMESPACE, "Action", WSADDRESSING_PREFIX);

}
