package com.ebmwebsourcing.wsaddressing10.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectSchemaBindingImpl;
import com.ebmwebsourcing.wsaddressing10.api.Constants;


// TODO : should not be public but imposed by ServiceLoader
public final class XmlObjectSchemaBindingImpl extends
        AbstractXmlObjectSchemaBindingImpl {

    @Override
    public String getName() {
        return "wsaddressing10-impl";
    }
    
    @Override
    public String getOriginatingSchemaDir() {
        return "schema/wsaddressing10";
    }

    @Override
    public String getOriginatingSchemaName() {
        return "wsaddressing10.xsd";
    }

    @Override
    public Package getModelObjectPackage() {
        return easybox.org.w3._2005._08.addressing.ObjectFactory.class.getPackage();
    }

    
    @Override
    public String getOriginatingSchemaNamespaceURI() {
        return Constants.WSADDRESSING_NS_URI;
    }
    
    @Override
    public String getOriginatingSchemaPreferredNamespacePrefix() {
        return Constants.WSADDRESSING_NS_PREFERRED_PREFIX;
    }
    
    
    @SuppressWarnings("unchecked")
    @Override
    public Class<? extends XmlObject>[] getFactorableClasses() {
        List<Class<? extends XmlObject>> factorableClasses = new ArrayList<Class<? extends XmlObject>>();
        
        // type
        factorableClasses.add(EndpointReferenceTypeImpl.class);
        factorableClasses.add(ReferenceParametersTypeImpl.class);
        factorableClasses.add(AttributedURITypeImpl.class);
        
        // element
        factorableClasses.add(AddressImpl.class);
        factorableClasses.add(EndpointReferenceImpl.class);
        factorableClasses.add(ReferenceParametersImpl.class);
        
        return factorableClasses.toArray(new Class[factorableClasses.size()]);
    }
    
    
    @Override
    protected XmlObject doWrap(XmlContext xmlContext,
            Constructor<? extends XmlObject> xmlObjectImplConstructor,
            ModelObject ModelObjectObject)
            throws InstantiationException, IllegalAccessException,
            InvocationTargetException {
        return xmlObjectImplConstructor.newInstance(xmlContext, ModelObjectObject);
    }

}
