package com.ebmwebsourcing.wsaddressing10.impl;



import java.net.URI;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.wsaddressing10.api.type.AttributedURIType;

import easybox.org.w3._2005._08.addressing.EJaxbAttributedURIType;

class AttributedURITypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbAttributedURIType> implements
AttributedURIType {

	protected AttributedURITypeImpl(XmlContext xmlContext, EJaxbAttributedURIType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbAttributedURIType> getCompliantModelClass() {
		return EJaxbAttributedURIType.class;
	}


	@Override
	public URI getValue() {
		if (getModelObject().getValue() == null) return null; 
		return URI.create(this.getModelObject().getValue().trim());
	}


	@Override
	public void setValue(URI value) {
		if (value == null) {
			getModelObject().setValue(null);
		} else {
			this.getModelObject().setValue(value.toString().trim());
		}
	}


	@Override
	public boolean hasValue() {
		return this.getValue() != null;
	}



	
}
