package com.ebmwebsourcing.wscap12.impl;



import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.wscap12.api.anonymoustype.EventCode;
import com.ebmwebsourcing.wscap12.api.anonymoustype.Info;
import com.ebmwebsourcing.wscap12.api.anonymoustype.Parameter;
import com.ebmwebsourcing.wscap12.api.anonymoustype.Resource;

import easybox.oasis.names.tc.emergency.cap._1.EJaxbAlert;


final class InfoImpl extends AbstractJaxbXmlObjectImpl<EJaxbAlert.Info> implements
Info {

	InfoImpl(XmlContext xmlContext, EJaxbAlert.Info jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbAlert.Info> getCompliantModelClass() {
		return EJaxbAlert.Info.class;
	}


	@Override
	public String getLanguage() {
		return this.getModelObject().getLanguage();
	}


	@Override
	public void setLanguage(String value) {
		this.getModelObject().setLanguage(value);
	}


	@Override
	public boolean hasLanguage() {
		return this.getModelObject().getLanguage() != null;
	}


	@Override
	public String[] getCategories() {
		return (String[]) this.getModelObject().getCategory().toArray();
	}


	@Override
	public void addCategory(String c) {
		this.getModelObject().getCategory().add(c);
	}


	@Override
	public void removeCategory(String c) {
		this.getModelObject().getCategory().remove(c);
	}


	@Override
	public void clearCategories() {
		this.getModelObject().getCategory().clear();
	}


	@Override
	public String getEvent() {
		return this.getModelObject().getEvent();
	}


	@Override
	public void setEvent(String value) {
		this.getModelObject().setEvent(value);
	}


	@Override
	public boolean hasEvent() {
		return this.getModelObject().getEvent() != null;
	}


	@Override
	public String[] getResponseTypes() {
		return (String[]) this.getModelObject().getResponseType().toArray();
	}


	@Override
	public void addResponseType(String c) {
		this.getModelObject().getResponseType().add(c);
	}


	@Override
	public void removeResponseType(String c) {
		this.getModelObject().getResponseType().remove(c);
	}


	@Override
	public void clearResponseTypes() {
		this.getModelObject().getResponseType().clear();
	}


	@Override
	public String getUrgency() {
		return this.getModelObject().getUrgency();
	}


	@Override
	public void setUrgency(String value) {
		this.getModelObject().setUrgency(value);
	}


	@Override
	public boolean hasUrgency() {
		return this.getModelObject().getUrgency() != null;
	}


	@Override
	public String getSeverity() {
		return this.getModelObject().getSeverity();
	}


	@Override
	public void setSeverity(String value) {
		this.getModelObject().setSeverity(value);
	}


	@Override
	public boolean hasSeverity() {
		return this.getModelObject().getSeverity() != null;
	}


	@Override
	public String getCertainty() {
		return this.getModelObject().getCertainty();
	}


	@Override
	public void setCertainty(String value) {
		this.getModelObject().setCertainty(value);
	}


	@Override
	public boolean hasCertainty() {
		return this.getModelObject().getCertainty() != null;
	}


	@Override
	public String getAudience() {
		return this.getModelObject().getAudience();
	}


	@Override
	public void setAudience(String value) {
		this.getModelObject().setAudience(value);
	}


	@Override
	public boolean hasAudience() {
		return this.getModelObject().getAudience() != null;
	}


	@Override
	public EventCode[] getEventCodes() {
		return createChildrenArray(getModelObject()
                .getEventCode(), EJaxbAlert.Info.EventCode.class, ANY_QNAME, 
                EventCode.class);
	}


	@Override
	public void addEventCode(EventCode c) {
		addToChildren(getModelObject().getEventCode(), c);
	}


	@Override
	public void removeEventCode(EventCode c) {
		removeFromChildren(getModelObject().getEventCode(), c);
	}


	@Override
	public void clearEventCodes() {
		clearChildren(getModelObject().getEventCode(),
				EJaxbAlert.Info.EventCode.class, ANY_QNAME);
	}


	@Override
	public EventCode getEventCodeByValueName(String name) {
		for (EventCode child : getEventCodes()) {
			if (name.equals(child.getValueName()))
				return child;
		}
		return null;
	}


	@Override
	public Date getEffective() {
		return this.getModelObject().getEffective().toGregorianCalendar().getTime();
	}


	@Override
	public void setEffective(Date value) {
		GregorianCalendar gCalendar = (GregorianCalendar) GregorianCalendar.getInstance();
		gCalendar.setTime(value);
		try {
			this.getModelObject().setEffective(DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar));
		} catch (DatatypeConfigurationException e) {
			throw new RuntimeException(e.getMessage(), e);
		}
	}


	@Override
	public boolean hasEffective() {
		return this.getModelObject().getEffective() != null;
	}


	@Override
	public Date getOnset() {
		return this.getModelObject().getOnset().toGregorianCalendar().getTime();
	}


	@Override
	public void setOnset(Date value) {
		GregorianCalendar gCalendar = (GregorianCalendar) GregorianCalendar.getInstance();
		gCalendar.setTime(value);
		try {
			this.getModelObject().setOnset(DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar));
		} catch (DatatypeConfigurationException e) {
			throw new RuntimeException(e.getMessage(), e);
		}
	}


	@Override
	public boolean hasOnset() {
		return this.getModelObject().getOnset() != null;
	}


	@Override
	public Date getExpires() {
		return this.getModelObject().getExpires().toGregorianCalendar().getTime();
	}


	@Override
	public void setExpires(Date value) {
		GregorianCalendar gCalendar = (GregorianCalendar) GregorianCalendar.getInstance();
		gCalendar.setTime(value);
		try {
			this.getModelObject().setExpires(DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar));
		} catch (DatatypeConfigurationException e) {
			throw new RuntimeException(e.getMessage(), e);
		}
	}


	@Override
	public boolean hasExpires() {
		return this.getModelObject().getExpires() != null;
	}


	@Override
	public String getSenderName() {
		return this.getModelObject().getSenderName();
	}


	@Override
	public void setSenderName(String value) {
		this.getModelObject().setSenderName(value);
	}


	@Override
	public boolean hasSenderName() {
		return this.getModelObject().getSenderName() != null;
	}


	@Override
	public String getHeadline() {
		return this.getModelObject().getHeadline();
	}


	@Override
	public void setHeadline(String value) {
		this.getModelObject().setHeadline(value);
	}


	@Override
	public boolean hasHeadline() {
		return this.getModelObject().getHeadline() != null;
	}


	@Override
	public String getDescription() {
		return this.getModelObject().getDescription();
	}


	@Override
	public void setDescription(String value) {
		this.getModelObject().setDescription(value);
	}


	@Override
	public boolean hasDescription() {
		return this.getModelObject().getDescription() != null;
	}


	@Override
	public String getInstruction() {
		return this.getModelObject().getInstruction();
	}


	@Override
	public void setInstruction(String value) {
		this.getModelObject().setInstruction(value);
	}


	@Override
	public boolean hasInstruction() {
		return this.getModelObject().getInstruction() != null;
	}


	@Override
	public String getWeb() {
		return this.getModelObject().getWeb();
	}


	@Override
	public void setWeb(String value) {
		this.getModelObject().setWeb(value);
	}


	@Override
	public boolean hasWeb() {
		return this.getModelObject().getWeb() != null;
	}


	@Override
	public String getContact() {
		return this.getModelObject().getContact();
	}


	@Override
	public void setContact(String value) {
		this.getModelObject().setContact(value);
	}


	@Override
	public boolean hasContact() {
		return this.getModelObject().getContact() != null;
	}


	@Override
	public Parameter[] getParameters() {
		return createChildrenArray(getModelObject()
                .getParameter(), EJaxbAlert.Info.Parameter.class, ANY_QNAME, 
                Parameter.class);
	}


	@Override
	public void addParameter(Parameter p) {
		addToChildren(getModelObject().getParameter(), p);
	}


	@Override
	public void removeParameter(Parameter p) {
		removeFromChildren(getModelObject().getParameter(), p);
	}


	@Override
	public void clearParameters() {
		clearChildren(getModelObject().getParameter(),
				EJaxbAlert.Info.Parameter.class, ANY_QNAME);
	}


	@Override
	public Parameter getParameterByValueName(String name) {
		for (Parameter child : getParameters()) {
			if (name.equals(child.getValueName()))
				return child;
		}
		return null;
	}


	@Override
	public Resource[] getResources() {
		return createChildrenArray(getModelObject()
                .getResource(), EJaxbAlert.Info.Resource.class, ANY_QNAME, 
                Resource.class);
	}


	@Override
	public void addResource(Resource c) {
		addToChildren(getModelObject().getResource(), c);
	}


	@Override
	public void removeResource(Resource c) {
		removeFromChildren(getModelObject().getResource(), c);
	}


	@Override
	public void clearResources() {
		clearChildren(getModelObject().getResource(),
				EJaxbAlert.Info.Resource.class, ANY_QNAME);
	}


	@Override
	public Resource getResourceByUri(String uri) {
		for (Resource child : getResources()) {
			if (uri.equals(child.getUri()))
				return child;
		}
		return null;
	}



	

}
