/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.api.service.alerte;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jeinnov.jeitime.api.service.collaborateur.ResultTransformerCollaborateur;
import org.jeinnov.jeitime.api.service.utils.CalculDate;
import org.jeinnov.jeitime.api.to.alerte.AlertesTO;
import org.jeinnov.jeitime.api.to.collaborateur.CollaborateurTO;
import org.jeinnov.jeitime.persistence.bo.projet.LienTachUtilP;
import org.jeinnov.jeitime.persistence.dao.alerte.AlerteDAO;
import org.jeinnov.jeitime.utils.HibernateUtil;

public class AlerteManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private AlerteDAO alerteDAO = AlerteDAO.getInstance();
    private CalculDate calculDate = new CalculDate();
    private static AlerteManager manager;

    public static AlerteManager getInstance() {
        if (manager == null) {
            manager = new AlerteManager();
        }
        return manager;
    }

    public List<AlertesTO> getAlertForYear(int year) {
        ArrayList<AlertesTO> listAlert = new ArrayList();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            Timestamp startDate = this.calculDate.getDateStartYear(year);
            Timestamp endDate = this.calculDate.getDateEndYear(year);
            List listLTU = this.alerteDAO.getAllByStartDateAndEndDate(startDate, endDate);
            String indicDate = String.valueOf(year);
            listAlert = this.getAlertesTO(listLTU, indicDate, 1);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return listAlert;
    }

    public List<AlertesTO> getAlertForMonth(int year, int month) {
        List listLTU = new ArrayList();
        CalculDate calculteDate = new CalculDate();
        ArrayList<AlertesTO> listAlert = new ArrayList();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            Timestamp startDate = this.calculDate.getDateStartMonth(year, month);
            Timestamp endDate = this.calculDate.getDateEndMonth(year, month);
            listLTU = this.alerteDAO.getAllByStartDateAndEndDate(startDate, endDate);
            String indicDate = calculteDate.getMonth(month);
            listAlert = this.getAlertesTO(listLTU, indicDate, 2);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return listAlert;
    }

    public List<AlertesTO> getAlertForWeek(Date date) {
        List listLTU = new ArrayList();
        ArrayList<AlertesTO> listAlert = new ArrayList();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            Timestamp startDate = this.calculDate.getDateStartWeek(date);
            Timestamp endDate = this.calculDate.getDateEndWeek(date);
            listLTU = this.alerteDAO.getAllByStartDateAndEndDate(startDate, endDate);
            Locale locale = Locale.FRANCE;
            DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
            String dateFe = dateFormat.format(endDate);
            String dateDe = dateFormat.format(startDate);
            String indicDate = "du " + dateDe + " au " + dateFe;
            listAlert = this.getAlertesTO(listLTU, indicDate, 3);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return listAlert;
    }

    private List<AlertesTO> getAlertesTO(List<LienTachUtilP> listLTU, String indicDate, int alerteType) {
        ResultTransformerCollaborateur resultTransformer = new ResultTransformerCollaborateur();
        ArrayList<AlertesTO> listAlert = new ArrayList<AlertesTO>();
        float nbheureSaisie = 0.0f;
        for (int i = 0; i < listLTU.size(); ++i) {
            nbheureSaisie = Float.valueOf(listLTU.get(i).getNbHeure()).floatValue();
            int j = i + 1;
            while (j < listLTU.size()) {
                if (listLTU.get(i).getCollaborateur().getIdColl() == listLTU.get(j).getCollaborateur().getIdColl()) {
                    float nbheureS = Float.valueOf(listLTU.get(j).getNbHeure()).floatValue();
                    nbheureSaisie += nbheureS;
                    listLTU.remove(j);
                    continue;
                }
                ++j;
            }
            CollaborateurTO collab = resultTransformer.toCollaborateurTO(listLTU.get(i).getCollaborateur());
            float nbCollege = 0.0f;
            nbCollege = alerteType == 1 ? Float.valueOf(collab.getNbHeureAnn()).floatValue() : (alerteType == 2 ? Float.valueOf(collab.getNbHeureMens()).floatValue() : Float.valueOf(collab.getNbHeureHeb()).floatValue());
            float difference = 0.0f;
            if (!(nbheureSaisie > nbCollege)) continue;
            difference = nbheureSaisie - nbCollege;
            AlertesTO alerte = new AlertesTO();
            alerte.setIndicDate(indicDate);
            alerte.setCollab(collab);
            alerte.setDifference(difference);
            alerte.setNbheureCollege(nbCollege);
            alerte.setNbheureSaisie(nbheureSaisie);
            listAlert.add(alerte);
        }
        return listAlert;
    }
}

