/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.api.service.projet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jeinnov.jeitime.api.service.projet.NomTacheManager;
import org.jeinnov.jeitime.api.service.projet.ProjetException;
import org.jeinnov.jeitime.api.to.projet.NomTacheTO;
import org.jeinnov.jeitime.api.to.projet.TacheTO;
import org.jeinnov.jeitime.api.to.projet.TypeTacheTO;
import org.jeinnov.jeitime.persistence.bo.projet.TypeTacheP;
import org.jeinnov.jeitime.persistence.dao.projet.TypeTacheDAO;
import org.jeinnov.jeitime.utils.HibernateUtil;

public class TypeTacheManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private TypeTacheDAO typeTacheDAO = TypeTacheDAO.getInstance();
    private static TypeTacheManager manager;

    public static TypeTacheManager getInstance() {
        if (manager == null) {
            manager = new TypeTacheManager();
        }
        return manager;
    }

    public TypeTacheTO get(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucun Type de T\u00e2che n'est s\u00e9lectionn\u00e9.");
        }
        TypeTacheTO typeTTO = new TypeTacheTO();
        TypeTacheP typeTP = new TypeTacheP();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            typeTP = (TypeTacheP)this.typeTacheDAO.find((Serializable)Integer.valueOf(id));
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (typeTP == null) {
            throw new ProjetException("Attention aucun Type de T\u00e2che existe avec cet identifiant dans la base.");
        }
        typeTTO.setIdTypTach(typeTP.getIdTypeTache());
        typeTTO.setNomTypTach(typeTP.getNomTypeTache());
        return typeTTO;
    }

    public List<TypeTacheTO> getAll() {
        ArrayList<TypeTacheTO> listTypeTTO = new ArrayList<TypeTacheTO>();
        List listTypeTP = new ArrayList();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            listTypeTP = this.typeTacheDAO.getAll();
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (listTypeTP != null) {
            for (TypeTacheP typeTP : listTypeTP) {
                TypeTacheTO typeTTO = new TypeTacheTO();
                typeTTO.setIdTypTach(typeTP.getIdTypeTache());
                typeTTO.setNomTypTach(typeTP.getNomTypeTache());
                listTypeTTO.add(typeTTO);
            }
        }
        return listTypeTTO;
    }

    public List<TypeTacheTO> getAllTypeTacheInProject(List<TacheTO> alltaches) {
        ArrayList<TypeTacheTO> listTypeTTO = new ArrayList<TypeTacheTO>();
        for (TacheTO t : alltaches) {
            TypeTacheTO tTTO = new TypeTacheTO();
            tTTO.setIdTypTach(t.getNomtache().getTypeTache().getIdTypTach());
            tTTO.setNomTypTach(t.getNomtache().getTypeTache().getNomTypTach());
            listTypeTTO.add(tTTO);
        }
        return listTypeTTO;
    }

    public int saveOrUpdate(TypeTacheTO typeTTO) throws ProjetException {
        if (typeTTO == null) {
            throw new ProjetException("Attention aucun type de T\u00e2che n'est s\u00e9lectionn\u00e9");
        }
        if (typeTTO.getNomTypTach() == null) {
            throw new ProjetException("Attention aucun nom n'a \u00e9t\u00e9 donn\u00e9 au type de T\u00e2che ");
        }
        TypeTacheP typeTP = new TypeTacheP();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            typeTP = this.typeTacheDAO.getByName(typeTTO.getNomTypTach());
            this.verificationAvantEnregistrement(typeTTO, typeTP);
            if (typeTP == null || typeTP.getIdTypeTache() == 0) {
                typeTP = new TypeTacheP();
            }
            typeTP.setIdTypeTache(typeTTO.getIdTypTach());
            typeTP.setNomTypeTache(typeTTO.getNomTypTach());
            this.typeTacheDAO.save((Object)typeTP);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        int id = typeTP.getIdTypeTache();
        return id;
    }

    public void delete(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucun type de T\u00e2che n'est s\u00e9lectionn\u00e9");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            TypeTacheP typeTP = (TypeTacheP)this.typeTacheDAO.find((Serializable)Integer.valueOf(id));
            this.typeTacheDAO.remove((Object)typeTP);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public boolean isInNomTache(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucun Type de T\u00e2che n'est s\u00e9lectionn\u00e9.");
        }
        boolean verif = false;
        List list = new ArrayList();
        try {
            list = NomTacheManager.getInstance().getAllByIdTypeTache(id);
            if (list == null || list.isEmpty()) {
                verif = false;
            } else {
                for (NomTacheTO nomT : list) {
                    verif = NomTacheManager.getInstance().isInTache(nomT.getIdNomTache());
                }
            }
        }
        catch (RuntimeException e) {
            verif = true;
            throw e;
        }
        return verif;
    }

    private void verificationAvantEnregistrement(TypeTacheTO typePT, TypeTacheP typePP) throws ProjetException {
        if (typePP != null && typePP.getIdTypeTache() != typePT.getIdTypTach()) {
            throw new ProjetException("Attention,un type de T\u00e2che avec ce nom existe d\u00e9j\u00e0 !");
        }
    }
}

