/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.bilan;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jeinnov.jeitime.api.service.bilan.BilanException;
import org.jeinnov.jeitime.api.service.bilan.RecapProjetManager;
import org.jeinnov.jeitime.api.service.collaborateur.CollaborateurManager;
import org.jeinnov.jeitime.api.service.projet.ProjetManager;
import org.jeinnov.jeitime.api.to.bilan.RecapProjetTO;
import org.jeinnov.jeitime.api.to.bilan.SousTotal;
import org.jeinnov.jeitime.api.to.collaborateur.CollaborateurTO;
import org.jeinnov.jeitime.api.to.projet.ProjetTO;
import org.jeinnov.jeitime.api.to.projet.TacheTO;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.opensuit.core.validation.LocalizedValidationError;
import org.ow2.opensuit.core.validation.ValidationError;
import org.ow2.opensuit.core.validation.ValidationErrors;

public class RecapProjetUIBean {
    private Date dateDeb;
    private String dateD;
    private Date dateFin;
    private String dateF;
    private boolean voirTabl = false;
    private boolean voirProj = false;
    private boolean voirDate = true;
    private int[] selectedProjet;
    private List<ProjetTO> allprojet = new ArrayList();
    private List<RecapProjetTO> listRecap = new ArrayList();
    private List<Object> items = new ArrayList();
    private List<CollaborateurTO> collaborateurs = new ArrayList();

    public void load() {
        this.items = new ArrayList();
        this.listRecap = new ArrayList();
        this.allprojet = new ArrayList();
        this.allprojet = ProjetManager.getInstance().getAll();
        this.voirDate = true;
        this.voirProj = false;
        this.voirTabl = false;
    }

    public void envoyer() {
        this.voirProj = true;
    }

    public void reset() {
        this.items = new ArrayList();
        this.listRecap = new ArrayList();
        this.allprojet = new ArrayList();
        this.allprojet = ProjetManager.getInstance().getAll();
        this.voirDate = true;
        this.voirProj = false;
        this.voirTabl = false;
        this.dateDeb = null;
        this.dateFin = null;
        this.selectedProjet = null;
    }

    public void voirTableau() throws IError {
        Locale locale = Locale.FRANCE;
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        this.dateD = dateFormat.format(this.dateDeb);
        this.dateF = dateFormat.format(this.dateFin);
        this.collaborateurs = CollaborateurManager.getInstance().getAll();
        try {
            this.items = RecapProjetManager.getInstance().listTache(this.selectedProjet);
        }
        catch (BilanException e) {
            NonLocalizedError error = new NonLocalizedError("Attention, aucun projet n'est associ\u00e9", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        try {
            this.listRecap = RecapProjetManager.getInstance().creerListRecapProjet(this.selectedProjet, this.dateDeb, this.dateFin);
        }
        catch (BilanException e) {
            NonLocalizedError error = new NonLocalizedError("Attention, aucun projet n'est associ\u00e9", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.voirTabl = true;
        this.voirProj = false;
        this.voirDate = false;
    }

    public String getHtmlName(Object item) {
        if (item instanceof String) {
            return "\\html\\<span class=sousTitleTable>" + item + "</span>";
        }
        if (item instanceof Integer) {
            return "Total";
        }
        if (item instanceof SousTotal) {
            return ((SousTotal)item).getNomSousTotal();
        }
        return ((TacheTO)item).getNomtache().getNomTache();
    }

    public String getValue(Object item, CollaborateurTO collab) {
        if (item instanceof String) {
            return null;
        }
        if (item instanceof Integer) {
            return this.itemsInstanceOfInteger(item, collab);
        }
        if (item instanceof SousTotal) {
            return this.itemsInstanceOfSousTotal(item, collab);
        }
        return this.itemsInstanceOfTacheTO(item, collab);
    }

    public void validate() throws ValidationErrors {
        ValidationErrors errors = new ValidationErrors();
        if (this.dateDeb != null && this.dateFin != null && this.dateFin.before(this.dateDeb)) {
            errors.addItemError("recapTousProjets.dateFin", (ValidationError)new LocalizedValidationError("validation.date"));
        }
        if (errors.hasErrors()) {
            throw errors;
        }
    }

    private String itemsInstanceOfInteger(Object item, CollaborateurTO collab) {
        String nb = "0";
        int idP = (Integer)item;
        double nbht = 0.0;
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (((RecapProjetTO)this.listRecap.get(i)).getCollab().getIdColl() != collab.getIdColl() || ((RecapProjetTO)this.listRecap.get(i)).getNomProjet().getIdProjet() != idP) continue;
            nbht = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbht;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbht);
        }
        return nb;
    }

    private String itemsInstanceOfSousTotal(Object item, CollaborateurTO collab) {
        String nb = "0";
        int idP = ((SousTotal)item).getIdProjet();
        boolean rd = ((SousTotal)item).isRd();
        double nbht = 0.0;
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (((RecapProjetTO)this.listRecap.get(i)).getCollab().getIdColl() != collab.getIdColl() || ((RecapProjetTO)this.listRecap.get(i)).getNomProjet().getIdProjet() != idP || ((RecapProjetTO)this.listRecap.get(i)).getTache().isEligible() != rd) continue;
            nbht = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbht;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbht);
        }
        return nb;
    }

    private String itemsInstanceOfTacheTO(Object item, CollaborateurTO collab) {
        int idT = ((TacheTO)item).getIdTache();
        int idCo = collab.getIdColl();
        String nb = "";
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (idT != ((RecapProjetTO)this.listRecap.get(i)).getTache().getIdTache() || idCo != ((RecapProjetTO)this.listRecap.get(i)).getCollab().getIdColl()) continue;
            double nbh = ((RecapProjetTO)this.listRecap.get(i)).getNbheure();
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbh);
        }
        return nb;
    }

    public String getTotal(Object item) {
        double nbh = 0.0;
        String total = "0";
        if (item instanceof String) {
            return null;
        }
        if (item instanceof Integer) {
            total = this.totalInstanceOfInteger(item, nbh);
            return total;
        }
        if (item instanceof SousTotal) {
            total = this.totalInstanceOfSousTotal(item);
            return total;
        }
        total = this.totalInstanceOfTacheTO(item, nbh);
        return total;
    }

    private String totalInstanceOfInteger(Object item, double nbh) {
        for (int i = 0; i < this.listRecap.size(); ++i) {
            int idP = (Integer)item;
            if (idP != ((RecapProjetTO)this.listRecap.get(i)).getNomProjet().getIdProjet()) continue;
            nbh = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbh;
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        df.setDecimalSeparatorAlwaysShown(true);
        String total = df.format(nbh);
        return total;
    }

    private String totalInstanceOfSousTotal(Object item) {
        String totalTmp = null;
        int idP = ((SousTotal)item).getIdProjet();
        boolean rd = ((SousTotal)item).isRd();
        double nbht = 0.0;
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (((RecapProjetTO)this.listRecap.get(i)).getNomProjet().getIdProjet() != idP || ((RecapProjetTO)this.listRecap.get(i)).getTache().isEligible() != rd) continue;
            nbht = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbht;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            totalTmp = df.format(nbht);
        }
        return totalTmp;
    }

    private String totalInstanceOfTacheTO(Object item, double nbh) {
        int idT = ((TacheTO)item).getIdTache();
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (idT != ((RecapProjetTO)this.listRecap.get(i)).getTache().getIdTache()) continue;
            nbh = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbh;
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        df.setDecimalSeparatorAlwaysShown(true);
        String total = df.format(nbh);
        return total;
    }

    public void selectAll() {
        this.selectedProjet = new int[this.allprojet.size()];
        for (int i = 0; i < this.allprojet.size(); ++i) {
            this.selectedProjet[i] = ((ProjetTO)this.allprojet.get(i)).getIdProjet();
        }
    }

    public void deSelectAll() {
        this.selectedProjet = null;
    }

    public Date getDateDeb() {
        return this.dateDeb;
    }

    public void setDateDeb(Date dateDeb) {
        this.dateDeb = dateDeb;
    }

    public Date getDateFin() {
        return this.dateFin;
    }

    public void setDateFin(Date dateFin) {
        this.dateFin = dateFin;
    }

    public int[] getSelectedProjet() {
        return this.selectedProjet;
    }

    public void setSelectedProjet(int[] selectedProjet) {
        this.selectedProjet = selectedProjet;
    }

    public List<ProjetTO> getAllprojet() {
        return this.allprojet;
    }

    public void setAllprojet(List<ProjetTO> allprojet) {
        this.allprojet = allprojet;
    }

    public List<Object> getItems() {
        return this.items;
    }

    public void setItems(List<Object> items) {
        this.items = items;
    }

    public List<CollaborateurTO> getCollaborateurs() {
        return this.collaborateurs;
    }

    public void setCollaborateurs(List<CollaborateurTO> collaborateurs) {
        this.collaborateurs = collaborateurs;
    }

    public boolean isVoirTabl() {
        return this.voirTabl;
    }

    public void setVoirTabl(boolean voirTabl) {
        this.voirTabl = voirTabl;
    }

    public boolean isVoirProj() {
        return this.voirProj;
    }

    public void setVoirProj(boolean voirProj) {
        this.voirProj = voirProj;
    }

    public List<RecapProjetTO> getListRecap() {
        return this.listRecap;
    }

    public void setListRecap(List<RecapProjetTO> listRecap) {
        this.listRecap = listRecap;
    }

    public boolean isVoirDate() {
        return this.voirDate;
    }

    public void setVoirDate(boolean voirDate) {
        this.voirDate = voirDate;
    }

    public String getDateD() {
        return this.dateD;
    }

    public void setDateD(String dateD) {
        this.dateD = dateD;
    }

    public String getDateF() {
        return this.dateF;
    }

    public void setDateF(String dateF) {
        this.dateF = dateF;
    }
}

