/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.projet;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jeinnov.jeitime.api.service.projet.ContratManager;
import org.jeinnov.jeitime.api.service.projet.ProjetException;
import org.jeinnov.jeitime.api.service.projet.ProjetManager;
import org.jeinnov.jeitime.api.service.projet.TacheManager;
import org.jeinnov.jeitime.api.to.projet.ProjetTO;
import org.jeinnov.jeitime.api.to.projet.TacheTO;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.NonLocalizedError;

public class ListsProjetUIBean {
    private ProjetManager projetManager = ProjetManager.getInstance();
    private TacheManager tacheManager = TacheManager.getInstance();
    private List<TacheTO> alltache;
    private List<ProjetTO> allprojet;
    private List<ProjetTO> listProjetFerme;
    private List<ProjetTO> listProjetNonFerme;
    private List<ProjetTO> listProjetCloture;
    private List<ProjetTO> listProjetNonCloture;
    private int[] selected;

    public void load() {
        this.allprojet = new ArrayList();
        this.allprojet = this.projetManager.getAllNotLock();
    }

    public void listerProjetFerme() {
        this.listProjetFerme = new ArrayList();
        this.listProjetFerme = this.projetManager.getAllClose();
    }

    public void listerProjetNonFerme() {
        this.listProjetNonFerme = new ArrayList();
        this.listProjetNonFerme = this.projetManager.getAllNotClose();
    }

    public void listerProjetClos() {
        this.listProjetCloture = new ArrayList();
        this.listProjetCloture = this.projetManager.getAllLock();
    }

    public void listerProjetNonClos() {
        this.listProjetNonCloture = new ArrayList();
        this.listProjetNonCloture = this.projetManager.getAllNotLock();
    }

    public boolean isInLienTach(int id) {
        boolean verif = this.projetManager.isInLienTachUtil(id);
        return verif;
    }

    public void delete(HttpServletRequest iRequest) throws IError, ProjetException {
        int id = Integer.parseInt(iRequest.getParameter("ID"));
        TacheManager.getInstance().deleteAllTacheInProject(id);
        ContratManager.getInstance().delete(id);
        try {
            this.projetManager.delete(id);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue, le projet n'a pas pu \u00eatre supprim\u00e9.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
    }

    public void searchCopy(HttpServletRequest iRequest) throws IError, ProjetException {
        int idP;
        int id = Integer.parseInt(iRequest.getParameter("id"));
        ProjetTO projet = this.projetManager.get(id);
        StringBuilder builder = new StringBuilder(projet.getNomProjet());
        builder.append(" Copie");
        this.alltache = TacheManager.getInstance().getAllTacheInProject(projet.getIdProjet());
        projet.setNomProjet(builder.toString());
        projet.setIdProjet(0);
        try {
            idP = this.projetManager.saveOrUpdate(projet);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue, le projet n'a pas pu etre sauvegard\u00e9. Un autre projet existe peut-\u00eatre d\u00e9j\u00e0 avec ce nom. ", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.saveAllTaches(idP);
        this.load();
    }

    private void saveAllTaches(int idP) throws IError {
        for (TacheTO tache : this.alltache) {
            tache.setProjet(new ProjetTO(idP));
            tache.setIdTache(0);
            try {
                this.tacheManager.saveOrUpdate(tache);
            }
            catch (ProjetException e) {
                NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. La t\u00e2che n'a pas pu \u00eatre sauvegard\u00e9e.", (Throwable)e);
                error.setType((short)0);
                throw error;
            }
        }
    }

    public void deselect() throws ProjetException {
        for (int i = 0; i < this.selected.length; ++i) {
            int id = this.selected[i];
            this.projetManager.openProject(id);
        }
        this.listerProjetFerme();
    }

    public void selectClo() throws ProjetException {
        for (int i = 0; i < this.selected.length; ++i) {
            int id = this.selected[i];
            this.projetManager.lockProject(id);
        }
        this.listerProjetNonClos();
    }

    public void select() throws ProjetException {
        for (int i = 0; i < this.selected.length; ++i) {
            int id = this.selected[i];
            this.projetManager.closeProject(id);
        }
        this.listerProjetNonFerme();
    }

    public List<TacheTO> getAlltache() {
        return this.alltache;
    }

    public void setAlltache(List<TacheTO> alltache) {
        this.alltache = alltache;
    }

    public List<ProjetTO> getAllprojet() {
        return this.allprojet;
    }

    public void setAllprojet(List<ProjetTO> allprojet) {
        this.allprojet = allprojet;
    }

    public List<ProjetTO> getListProjetFerme() {
        return this.listProjetFerme;
    }

    public void setListProjetFerme(List<ProjetTO> listProjetFerme) {
        this.listProjetFerme = listProjetFerme;
    }

    public List<ProjetTO> getListProjetNonFerme() {
        return this.listProjetNonFerme;
    }

    public void setListProjetNonFerme(List<ProjetTO> listProjetNonFerme) {
        this.listProjetNonFerme = listProjetNonFerme;
    }

    public List<ProjetTO> getListProjetCloture() {
        return this.listProjetCloture;
    }

    public void setListProjetCloture(List<ProjetTO> listProjetCloture) {
        this.listProjetCloture = listProjetCloture;
    }

    public List<ProjetTO> getListProjetNonCloture() {
        return this.listProjetNonCloture;
    }

    public void setListProjetNonCloture(List<ProjetTO> listProjetNonCloture) {
        this.listProjetNonCloture = listProjetNonCloture;
    }

    public int[] getSelected() {
        return this.selected;
    }

    public void setSelected(int[] selected) {
        this.selected = selected;
    }
}

