/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.utils;

import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeinnov.jeitime.persistence.bo.collaborateur.CollaborateurP;
import org.ow2.opensuit.core.session.OpenSuitSession;
import org.ow2.opensuit.core.util.BeanUtils;

public class UserConfig {
    private final Logger logger = Logger.getLogger(this.getClass());
    private CollaborateurP collab;

    public final UserConfig getCurrent(HttpServletRequest request) {
        try {
            return (UserConfig)BeanUtils.getOpenSuitBean((HttpServletRequest)OpenSuitSession.getCurrentRequest(), (String)"userConfig");
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Locale getLocale() {
        HttpServletRequest request = OpenSuitSession.getCurrentRequest();
        Cookie[] cookies = request.getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().equals("lang")) continue;
            return new Locale(cookies[i].getValue());
        }
        OpenSuitSession.getSession((HttpServletRequest)request);
        return OpenSuitSession.getCurrentApplication().getAllLanguages()[0].getLocale();
    }

    public void setLocale(Locale locale) {
        HttpServletRequest request = OpenSuitSession.getCurrentRequest();
        HttpServletResponse response = OpenSuitSession.getCurrentResponse();
        Cookie langCookie = new Cookie("lang", locale.getLanguage());
        langCookie.setPath(request.getContextPath());
        response.addCookie(langCookie);
    }

    public String getIdentity() {
        if (this.collab != null) {
            return this.collab.getNameAppli();
        }
        HttpServletRequest req = OpenSuitSession.getCurrentRequest();
        return req.getUserPrincipal().getName();
    }

    public int getPaginationLength() {
        return 20;
    }

    public void disconnect(HttpServletRequest request) {
        request.getSession().invalidate();
    }

    public CollaborateurP getCollab() {
        return this.collab;
    }

    public void setCollab(CollaborateurP collab) {
        this.collab = collab;
    }
}

