/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.chors.bus;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.ow2.choreos.chors.bus.BusHandler;
import org.ow2.choreos.chors.bus.ESBNodesSelector;
import org.ow2.choreos.chors.bus.EasyESBNode;
import org.ow2.choreos.chors.bus.InstancesFilter;
import org.ow2.choreos.chors.bus.NoBusAvailableException;
import org.ow2.choreos.chors.datamodel.Choreography;
import org.ow2.choreos.services.datamodel.ServiceInstance;
import org.ow2.choreos.utils.Concurrency;

public class BaseESBNodeSelector
implements ESBNodesSelector {
    private static final int BUS_SELECTION_TIMEOUT = 10;
    private Logger logger = Logger.getLogger(BaseESBNodeSelector.class);
    private Map<ServiceInstance, EasyESBNode> selectedNodes;
    private BusHandler busHandler;

    public BaseESBNodeSelector(BusHandler busHandler) {
        this.busHandler = busHandler;
    }

    @Override
    public Map<ServiceInstance, EasyESBNode> selectESBNodes(Choreography choreography) {
        this.logger.info((Object)"Selecting ESB Nodes");
        this.selectedNodes = new ConcurrentHashMap<ServiceInstance, EasyESBNode>();
        List<ServiceInstance> instances = this.removeCoordels(choreography);
        int N = instances.size();
        ExecutorService executor = Executors.newFixedThreadPool(N);
        for (ServiceInstance svcInstance : instances) {
            Selector selector = new Selector(svcInstance);
            executor.submit(selector);
        }
        Concurrency.waitExecutor((ExecutorService)executor, (int)10, (Logger)this.logger);
        this.logger.info((Object)"Nodes are already selected");
        return Collections.unmodifiableMap(this.selectedNodes);
    }

    private List<ServiceInstance> removeCoordels(Choreography chor) {
        InstancesFilter filter = new InstancesFilter();
        return filter.filter(chor.getChoreographyServices());
    }

    private class Selector
    implements Runnable {
        ServiceInstance svcInstance;

        Selector(ServiceInstance svcInstance) {
            this.svcInstance = svcInstance;
        }

        @Override
        public void run() {
            String svcName = this.svcInstance.getServiceSpec().getUUID();
            try {
                EasyESBNode esbNode = BaseESBNodeSelector.this.busHandler.retrieveBusNode();
                BaseESBNodeSelector.this.selectedNodes.put(this.svcInstance, esbNode);
                BaseESBNodeSelector.this.logger.debug((Object)("ESB node " + esbNode.getAdminEndpoint() + " selected to the " + svcName + " instance"));
            }
            catch (NoBusAvailableException e) {
                BaseESBNodeSelector.this.logger.error((Object)("Could not select esb node to " + svcName + " instance"));
                BaseESBNodeSelector.this.selectedNodes.put(this.svcInstance, null);
            }
        }
    }
}

