/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.chors.bus;

import org.ow2.choreos.chors.bus.BusHandler;
import org.ow2.choreos.chors.bus.EasyESBNode;
import org.ow2.choreos.chors.bus.NoBusAvailableException;
import org.ow2.choreos.chors.bus.SimpleBusHandler;
import org.ow2.choreos.nodes.NodePoolManager;

class SingleBusHandler
implements BusHandler {
    private static SingleBusHandler singleton;
    private int SYNC_WAIT_STEP = 30;
    private volatile EasyESBNode esbNode;
    private NodePoolManager npm;
    private boolean creating = false;

    public static synchronized SingleBusHandler getInstance(NodePoolManager npm) {
        if (singleton == null) {
            singleton = new SingleBusHandler(npm);
        }
        return singleton;
    }

    SingleBusHandler(NodePoolManager npm) {
        this.npm = npm;
    }

    SingleBusHandler(NodePoolManager npm, int waitStep) {
        this.npm = npm;
        this.SYNC_WAIT_STEP = 1;
    }

    @Override
    public EasyESBNode retrieveBusNode() throws NoBusAvailableException {
        this.sync();
        if (this.esbNode == null) {
            SimpleBusHandler simpleBusHandler = new SimpleBusHandler(this.npm);
            this.esbNode = simpleBusHandler.retrieveBusNode();
            this.creating = false;
        }
        return this.esbNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() {
        boolean wait = false;
        SingleBusHandler singleBusHandler = this;
        synchronized (singleBusHandler) {
            if (this.creating) {
                wait = true;
            }
            if (!this.creating && this.esbNode == null) {
                this.creating = true;
            }
        }
        if (wait) {
            while (this.creating) {
                this.sleep();
            }
        }
    }

    private void sleep() {
        try {
            Thread.sleep(this.SYNC_WAIT_STEP * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

