/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.chors.context;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ow2.choreos.chors.context.ContextNotSentException;
import org.ow2.choreos.chors.context.ContextSender;
import org.ow2.choreos.chors.datamodel.ChoreographyService;
import org.ow2.choreos.chors.datamodel.ChoreographyServiceDependency;
import org.ow2.choreos.chors.datamodel.ChoreographyServiceSpec;
import org.ow2.choreos.chors.datamodel.ChoreographySpec;
import org.ow2.choreos.services.datamodel.DeployableService;
import org.ow2.choreos.services.datamodel.ServiceInstance;
import org.ow2.choreos.services.datamodel.ServiceType;

public class ContextCaster {
    private Logger logger = Logger.getLogger(ContextCaster.class);
    private static final int MAX_TRIALS = 5;
    private static final int DELAY_BETWEEN_TRIALS = 30000;
    private ContextSender sender;

    public ContextCaster(ContextSender sender) {
        this.sender = sender;
    }

    public void cast(ChoreographySpec chor, Map<String, ChoreographyService> deployedServices) {
        this.logger.info((Object)"Passing context to deployed services");
        for (Map.Entry<String, ChoreographyService> entry : deployedServices.entrySet()) {
            ChoreographyService deployed = entry.getValue();
            this.castContext(deployedServices, deployed);
        }
    }

    private void castContext(Map<String, ChoreographyService> deployedServices, ChoreographyService deployed) {
        ChoreographyServiceSpec spec = deployed.getChoreographyServiceSpec();
        if (spec.getDependencies() == null) {
            return;
        }
        List serviceUris = deployed.getService().getUris();
        for (ChoreographyServiceDependency dep : spec.getDependencies()) {
            ChoreographyService providerService = deployedServices.get(dep.getChoreographyServiceUID());
            if (providerService == null) {
                this.logger.error((Object)("Service " + dep.getChoreographyServiceUID() + " (" + spec.getChoreographyServiceUID() + "dependency) not deployed. Not goint to pass this context to " + spec.getChoreographyServiceUID()));
                continue;
            }
            try {
                this.trySendContext(spec, serviceUris, dep, providerService);
            }
            catch (ContextNotSentException e) {
                this.logger.error((Object)("Could not setInvocationAddress to " + e.getServiceUri()));
            }
        }
    }

    private List<String> getUris(ChoreographyService providerService) {
        ArrayList<String> uris = new ArrayList<String>();
        for (ServiceInstance instance : ((DeployableService)providerService.getService()).getInstances()) {
            String proxifiedUri = instance.getBusUri(ServiceType.SOAP);
            if (proxifiedUri != null) {
                uris.add(proxifiedUri);
                continue;
            }
            uris.add(instance.getNativeUri());
        }
        return uris;
    }

    private void trySendContext(ChoreographyServiceSpec consumerServiceSpec, List<String> consumerServiceInstanceUris, ChoreographyServiceDependency consumerServiceDependency, ChoreographyService providerService) throws ContextNotSentException {
        List<String> providerUris = this.getUris(providerService);
        int trial = 0;
        Iterator<String> iterator = consumerServiceInstanceUris.iterator();
        if (iterator.hasNext()) {
            String serviceUri = iterator.next();
            while (trial < 5) {
                try {
                    this.sender.sendContext(serviceUri, consumerServiceDependency.getChoreographyServiceRole(), consumerServiceDependency.getChoreographyServiceUID(), providerUris);
                    this.logger.debug((Object)(String.valueOf(consumerServiceSpec.getChoreographyServiceUID()) + " has received " + consumerServiceDependency.getChoreographyServiceUID() + " as " + consumerServiceDependency.getChoreographyServiceRole() + ": " + providerUris));
                    return;
                }
                catch (ContextNotSentException e) {
                    trial = this.tryRecoveryNotSentContext(consumerServiceSpec, consumerServiceDependency, trial);
                    this.logger.error((Object)("Trial=" + trial));
                }
            }
            throw new ContextNotSentException(serviceUri, consumerServiceDependency.getChoreographyServiceRole(), consumerServiceDependency.getChoreographyServiceUID(), providerUris);
        }
    }

    private int tryRecoveryNotSentContext(ChoreographyServiceSpec spec, ChoreographyServiceDependency dep, int trial) {
        if (++trial == 5) {
            this.logger.error((Object)("Could not set " + dep.getChoreographyServiceUID() + " as " + dep.getChoreographyServiceRole() + " to " + spec.getChoreographyServiceUID()));
        }
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException e1) {
            this.logger.error((Object)"Exception at sleeping. This should not happen.");
        }
        return trial;
    }
}

