/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.client.CSGeneric;

import org.ow2.choreos.xsa.xsb.client.CSGeneric.CSScope;
import org.ow2.choreos.xsa.xsb.clients.generic.CallbackSystem;
import org.ow2.choreos.xsa.xsb.clients.generic.ICallbackScope;
import org.ow2.choreos.xsa.xsb.clients.generic.IProxyScope;
import org.ow2.choreos.xsa.xsb.clients.generic.ProxySystem;
import org.ow2.choreos.xsa.xsb.clients.generic.System;
import org.ow2.choreos.xsa.xsb.clients.generic.exceptions.SystemException;
import org.ow2.choreos.xsa.xsb.specifications.parsers.csdl.CSDLDefinition;
import org.ow2.choreos.xsa.xsb.specifications.parsers.csdl.TCSDLScopes;
import org.ow2.choreos.xsa.xsb.specifications.parsers.csdl.TOperation;
import org.ow2.choreos.xsa.xsb.specifications.parsers.csdl.utils.CachedCSDLDefinition;
import org.ow2.choreos.xsa.xsb.specifications.parsers.csdl.utils.CachedOperation;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TScopeID;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TSubscopeID;

public abstract class CSSystem<IO, D extends CachedCSDLDefinition<?>, D2 extends TScopeID, C extends ICallbackScope, P extends IProxyScope>
extends System<IO, D, CSScope<C, P>> {
    protected CallbackSystem<IO, D, D2, TSubscopeID, C> servicePart;
    protected ProxySystem<IO, D, P> proxysPart;

    public CSSystem(D definition) throws SystemException {
        super(definition);
        if (definition.hasIncomings()) {
            try {
                this.proxysPart = this.buildProxyPart();
            }
            catch (SystemException e) {
                this.logger.severe("The proxy part has not been built");
            }
        }
        if (definition.hasOutgoings()) {
            try {
                this.servicePart = this.buildServerPart();
            }
            catch (SystemException e) {
                this.logger.severe("The server part has not been built");
            }
        }
        this.buildScopes(definition);
    }

    protected abstract CallbackSystem<IO, D, D2, TSubscopeID, C> buildServerPart() throws SystemException;

    protected abstract ProxySystem<IO, D, P> buildProxyPart() throws SystemException;

    public void buildScopes(D definition) throws SystemException {
        TCSDLScopes scopes = (TCSDLScopes)((CSDLDefinition)definition.getDefinition()).getScopes().getValue();
        block6: for (TOperation operation : scopes.getOperation()) {
            TScopeID operationId = (TScopeID)operation.getScopeId().getValue();
            CachedOperation op = definition.getScope(operationId);
            switch (operation.getSemantic()) {
                case ONE_WAY: {
                    C c1 = this.buildOneWayCallbackScope(operationId);
                    CSScope scope1 = new CSScope(operationId.getId(), this, c1);
                    this.servicePart.addCallback(operationId, null, c1);
                    this.scopes.add(scope1);
                    continue block6;
                }
                case REQUEST_RESPONSE: {
                    C c2 = this.buildTwoWayCallbackScope(operationId);
                    CSScope scope2 = new CSScope(operationId.getId(), this, c2);
                    this.servicePart.addCallback(operationId, null, c2);
                    this.scopes.add(scope2);
                    continue block6;
                }
                case NOTIFICATION: {
                    P p1 = this.buildNotificationScope(operationId);
                    CSScope scope3 = new CSScope(operationId.getId(), this, p1);
                    this.proxysPart.addProxyScope(operationId, null, p1);
                    this.scopes.add(scope3);
                    continue block6;
                }
                case SOLICIT_RESPONSE: {
                    P p2 = this.buildSolicitResponseScope(operationId);
                    CSScope scope4 = new CSScope(operationId.getId(), this, p2);
                    this.proxysPart.addProxyScope(operationId, null, p2);
                    this.scopes.add(scope4);
                    continue block6;
                }
            }
        }
    }

    public abstract C buildOneWayCallbackScope(D2 var1) throws SystemException;

    public abstract C buildTwoWayCallbackScope(D2 var1) throws SystemException;

    public abstract P buildNotificationScope(D2 var1) throws SystemException;

    public abstract P buildSolicitResponseScope(D2 var1) throws SystemException;

    public CallbackSystem<IO, D, D2, TSubscopeID, C> getServicePart() {
        return this.servicePart;
    }

    public ProxySystem<IO, D, P> getProxysPart() {
        return this.proxysPart;
    }
}

