/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.gaPrimitives.tests;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.dom4j.DocumentException;
import org.hamcrest.AllOf;
import org.hamcrest.Matcher;
import org.hamcrest.beans.HasPropertyWithValue;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.hamsandwich.core.AdaptingMatcher;
import org.hamsandwich.core.CannotAdaptException;
import org.hamsandwich.core.HamSandwichFactory;
import org.ow2.choreos.xsa.xsb.gaPrimitives.GAMessageFactory;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TPolicy;
import org.ow2.choreos.xsa.xsb.specifications.parsers.ga.TCoupling;
import org.ow2.choreos.xsa.xsb.specifications.parsers.ga.TMainscope;
import org.ow2.choreos.xsa.xsb.specifications.parsers.ga.TSubscope;
import org.ow2.choreos.xsa.xsb.specifications.parsers.ga.TSubsubscope;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.GaMessage;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TData;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TEndGet;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TEndGetAsync;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TGAPrimitive;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TGetAsync;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TGetSync;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TGetSyncResponse;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TLease;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TPost;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TScope;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TSetupGet;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TSetupGetResponse;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TWait;
import org.ow2.choreos.xsa.xsb.utils.HasElementsContainingInOrder;
import org.ow2.choreos.xsa.xsb.utils.xml.IsXMLElementEquivalent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class GAMessageMatchers {
    protected static GAMessageFactory factory = new GAMessageFactory();

    @HamSandwichFactory
    public static Matcher<GaMessage> gaMessage(Matcher<TGAPrimitive> ... matchers) {
        return new AdaptingMatcher<GaMessage, Iterable<TGAPrimitive>>(new Matcher[]{HasElementsContainingInOrder.hasElementsInOrder(matchers)}){

            public Iterable<TGAPrimitive> get(GaMessage in) throws CannotAdaptException {
                ArrayList<TGAPrimitive> primitives = new ArrayList<TGAPrimitive>();
                for (JAXBElement elt : in.getGAPrimitive()) {
                    primitives.add((TGAPrimitive)elt.getValue());
                }
                return primitives;
            }
        };
    }

    @HamSandwichFactory
    public static Matcher<Document> asGAMessage(Matcher<TGAPrimitive> ... matchers) {
        return new AdaptingMatcher<Document, Iterable<TGAPrimitive>>(new Matcher[]{HasElementsContainingInOrder.hasElementsInOrder(matchers)}){

            public Iterable<TGAPrimitive> get(Document in) throws CannotAdaptException {
                try {
                    GaMessage message = factory.buildGAMessage(in);
                    ArrayList<TGAPrimitive> primitives = new ArrayList<TGAPrimitive>();
                    for (JAXBElement elt : message.getGAPrimitive()) {
                        primitives.add((TGAPrimitive)elt.getValue());
                    }
                    return primitives;
                }
                catch (JAXBException e) {
                    throw new CannotAdaptException();
                }
            }
        };
    }

    public static Matcher<TGAPrimitive> post(Matcher<TGAPrimitive> ... matchers) {
        return AllOf.allOf((Matcher)IsInstanceOf.instanceOf(TPost.class), (Matcher)AllOf.allOf(matchers));
    }

    public static Matcher<TGAPrimitive> setupGet(Matcher<TGAPrimitive> ... matchers) {
        return AllOf.allOf((Matcher)IsInstanceOf.instanceOf(TSetupGet.class), (Matcher)AllOf.allOf(matchers));
    }

    public static Matcher<TGAPrimitive> setupGetResponse(Matcher<TGAPrimitive> ... matchers) {
        return AllOf.allOf((Matcher)IsInstanceOf.instanceOf(TSetupGetResponse.class), (Matcher)AllOf.allOf(matchers));
    }

    public static Matcher<TGAPrimitive> getAsync(Matcher<TGAPrimitive> ... matchers) {
        return AllOf.allOf((Matcher)IsInstanceOf.instanceOf(TGetAsync.class), (Matcher)AllOf.allOf(matchers));
    }

    public static Matcher<TGAPrimitive> endGetAsync(Matcher<TGAPrimitive> ... matchers) {
        return AllOf.allOf((Matcher)IsInstanceOf.instanceOf(TEndGetAsync.class), (Matcher)AllOf.allOf(matchers));
    }

    public static Matcher<TGAPrimitive> getSync(Matcher<TGAPrimitive> ... matchers) {
        return AllOf.allOf((Matcher)IsInstanceOf.instanceOf(TGetSync.class), (Matcher)AllOf.allOf(matchers));
    }

    public static Matcher<TGAPrimitive> getSyncResponse(Matcher<TGAPrimitive> ... matchers) {
        return AllOf.allOf((Matcher)IsInstanceOf.instanceOf(TGetSyncResponse.class), (Matcher)AllOf.allOf(matchers));
    }

    public static Matcher<TGAPrimitive> endGet(Matcher<TGAPrimitive> ... matchers) {
        return AllOf.allOf((Matcher)IsInstanceOf.instanceOf(TEndGet.class), (Matcher)AllOf.allOf(matchers));
    }

    public static Matcher<TPost> asPost(Matcher<TGAPrimitive> ... matchers) {
        return AllOf.allOf((Matcher)IsInstanceOf.instanceOf(TPost.class), (Matcher)AllOf.allOf(matchers));
    }

    public static Matcher<TSetupGet> asSetupGet(Matcher<TGAPrimitive> ... matchers) {
        return AllOf.allOf((Matcher)IsInstanceOf.instanceOf(TSetupGet.class), (Matcher)AllOf.allOf(matchers));
    }

    public static Matcher<TSetupGetResponse> asSetupGetResponse(Matcher<TGAPrimitive> ... matchers) {
        return AllOf.allOf((Matcher)IsInstanceOf.instanceOf(TSetupGetResponse.class), (Matcher)AllOf.allOf(matchers));
    }

    public static Matcher<TGetAsync> asGetAsync(Matcher<TGAPrimitive> ... matchers) {
        return AllOf.allOf((Matcher)IsInstanceOf.instanceOf(TGetAsync.class), (Matcher)AllOf.allOf(matchers));
    }

    public static Matcher<TEndGetAsync> asEndGetAsync(Matcher<TGAPrimitive> ... matchers) {
        return AllOf.allOf((Matcher)IsInstanceOf.instanceOf(TEndGetAsync.class), (Matcher)AllOf.allOf(matchers));
    }

    public static Matcher<TGetSync> asGetSync(Matcher<TGAPrimitive> ... matchers) {
        return AllOf.allOf((Matcher)IsInstanceOf.instanceOf(TGetSync.class), (Matcher)AllOf.allOf(matchers));
    }

    public static Matcher<TGetSyncResponse> asGetSyncResponse(Matcher<TGAPrimitive> ... matchers) {
        return AllOf.allOf((Matcher)IsInstanceOf.instanceOf(TGetSyncResponse.class), (Matcher)AllOf.allOf(matchers));
    }

    public static Matcher<TEndGet> asEndGet(Matcher<TGAPrimitive> ... matchers) {
        return AllOf.allOf((Matcher)IsInstanceOf.instanceOf(TEndGet.class), (Matcher)AllOf.allOf(matchers));
    }

    @HamSandwichFactory
    public static Matcher<TGAPrimitive> coupling(TCoupling coupling) {
        return new AdaptingMatcher<TGAPrimitive, TCoupling>(new Matcher[]{IsEqual.equalTo((Object)coupling)}){

            public TCoupling get(TGAPrimitive in) throws CannotAdaptException {
                if (in instanceof TPost) {
                    return ((TPost)in).getCoupling();
                }
                if (in instanceof TSetupGet) {
                    return ((TSetupGet)in).getCoupling();
                }
                if (in instanceof TGetAsync) {
                    return ((TGetAsync)in).getCoupling();
                }
                if (in instanceof TGetSync) {
                    return ((TGetSync)in).getCoupling();
                }
                if (in instanceof TGetSyncResponse) {
                    return ((TGetSyncResponse)in).getCoupling();
                }
                return null;
            }
        };
    }

    @HamSandwichFactory
    public static Matcher<TGAPrimitive> policy(TPolicy policy) {
        return new AdaptingMatcher<TGAPrimitive, TPolicy>(new Matcher[]{IsEqual.equalTo((Object)policy)}){

            public TPolicy get(TGAPrimitive in) throws CannotAdaptException {
                if (in instanceof TGetSync) {
                    return ((TGetSync)in).getPolicy();
                }
                return null;
            }
        };
    }

    @HamSandwichFactory
    public static Matcher<TGAPrimitive> lease(Matcher<TLease> ... matchers) {
        return new AdaptingMatcher<TGAPrimitive, TLease>(matchers){

            public TLease get(TGAPrimitive in) throws CannotAdaptException {
                if (in instanceof TPost) {
                    return ((TPost)in).getLease();
                }
                return null;
            }
        };
    }

    public static Matcher<TLease> leaseForever() {
        return HasPropertyWithValue.hasProperty((String)"forever", (Matcher)IsNull.notNullValue());
    }

    public static Matcher<TLease> leaseValue(int value) {
        return HasPropertyWithValue.hasProperty((String)"value", (Matcher)IsEqual.equalTo((Object)value));
    }

    @HamSandwichFactory
    public static Matcher<TGAPrimitive> timeout(Matcher<TWait> ... matchers) {
        return new AdaptingMatcher<TGAPrimitive, TWait>(matchers){

            public TWait get(TGAPrimitive in) throws CannotAdaptException {
                if (in instanceof TGetSync) {
                    return ((TGetSync)in).getTimeout();
                }
                return null;
            }
        };
    }

    public static Matcher<TWait> timeoutWait() {
        return HasPropertyWithValue.hasProperty((String)"wait", (Matcher)IsNull.notNullValue());
    }

    public static Matcher<TWait> timeoutValue(int value) {
        return HasPropertyWithValue.hasProperty((String)"value", (Matcher)IsEqual.equalTo((Object)value));
    }

    @HamSandwichFactory
    public static Matcher<TScope> mainscope(Matcher<Element> matcher) throws SAXException, IOException, DocumentException {
        return new AdaptingMatcher<TScope, Element>(new Matcher[]{matcher}){

            public Element get(TScope in) throws CannotAdaptException {
                return in.getMainscope().getAny();
            }
        };
    }

    @HamSandwichFactory
    public static Matcher<TScope> subscope(Matcher<Element> matcher) throws SAXException, IOException, DocumentException {
        return new AdaptingMatcher<TScope, Element>(new Matcher[]{matcher}){

            public Element get(TScope in) throws CannotAdaptException {
                return in.getSubscope().getAny();
            }
        };
    }

    @HamSandwichFactory
    public static Matcher<TScope> subsubscope(Matcher<Element> matcher) throws SAXException, IOException, DocumentException {
        return new AdaptingMatcher<TScope, Element>(new Matcher[]{matcher}){

            public Element get(TScope in) throws CannotAdaptException {
                return in.getSubsubscope().getAny();
            }
        };
    }

    public static Matcher<TGAPrimitive> scope(TMainscope mainscope, TSubscope subscope, TSubsubscope subsubscope) throws SAXException, IOException, DocumentException {
        return GAMessageMatchers.scope((Matcher<Element>)IsXMLElementEquivalent.xmlElementEquivalent((Element)mainscope.getAny()), (Matcher<Element>)IsXMLElementEquivalent.xmlElementEquivalent((Element)subscope.getAny()), (Matcher<Element>)IsXMLElementEquivalent.xmlElementEquivalent((Element)subsubscope.getAny()));
    }

    @HamSandwichFactory
    public static Matcher<TGAPrimitive> scope(Matcher<Element> matcherMainscope, Matcher<Element> matcherSubscope, Matcher<Element> matcherSubsubscope) throws SAXException, IOException, DocumentException {
        return new AdaptingMatcher<TGAPrimitive, TScope>(new Matcher[]{GAMessageMatchers.mainscope(matcherMainscope), GAMessageMatchers.subscope(matcherSubscope), GAMessageMatchers.subsubscope(matcherSubsubscope)}){

            public TScope get(TGAPrimitive in) throws CannotAdaptException {
                if (in instanceof TPost) {
                    return ((TPost)in).getScope();
                }
                if (in instanceof TSetupGet) {
                    return ((TSetupGet)in).getScope();
                }
                return null;
            }
        };
    }

    @HamSandwichFactory
    public static Matcher<TGAPrimitive> callback(String value) throws SAXException, IOException, DocumentException {
        return new AdaptingMatcher<TGAPrimitive, String>(new Matcher[]{IsEqual.equalTo((Object)value)}){

            public String get(TGAPrimitive in) throws CannotAdaptException {
                if (in instanceof TGetAsync) {
                    return ((TGetAsync)in).getCallback();
                }
                return null;
            }
        };
    }

    @HamSandwichFactory
    public static Matcher<TGAPrimitive> scope(Matcher<TScope> ... matchers) throws SAXException, IOException, DocumentException {
        return new AdaptingMatcher<TGAPrimitive, TScope>(matchers){

            public TScope get(TGAPrimitive in) throws CannotAdaptException {
                if (in instanceof TPost) {
                    return ((TPost)in).getScope();
                }
                if (in instanceof TSetupGet) {
                    return ((TSetupGet)in).getScope();
                }
                return null;
            }
        };
    }

    @HamSandwichFactory
    public static Matcher<TGAPrimitive> correlation(Matcher<String> ... matchers) throws SAXException, IOException, DocumentException {
        return new AdaptingMatcher<TGAPrimitive, String>(matchers){

            public String get(TGAPrimitive in) throws CannotAdaptException {
                if (in instanceof TPost) {
                    return ((TPost)in).getCorrelation();
                }
                if (in instanceof TSetupGet) {
                    return ((TSetupGet)in).getCorrelation();
                }
                return null;
            }
        };
    }

    @HamSandwichFactory
    public static Matcher<TGAPrimitive> handle(Matcher<String> ... matchers) throws SAXException, IOException, DocumentException {
        return new AdaptingMatcher<TGAPrimitive, String>(matchers){

            public String get(TGAPrimitive in) throws CannotAdaptException {
                if (in instanceof TSetupGet) {
                    return ((TSetupGet)in).getHandle();
                }
                if (in instanceof TGetSync) {
                    return ((TGetSync)in).getHandle();
                }
                if (in instanceof TGetAsync) {
                    return ((TGetAsync)in).getHandle();
                }
                if (in instanceof TEndGet) {
                    return ((TEndGet)in).getHandle();
                }
                if (in instanceof TEndGetAsync) {
                    return ((TEndGetAsync)in).getHandle();
                }
                if (in instanceof TGetSyncResponse) {
                    return ((TGetSyncResponse)in).getHandle();
                }
                if (in instanceof TSetupGetResponse) {
                    return ((TSetupGetResponse)in).getHandle();
                }
                return null;
            }
        };
    }

    @HamSandwichFactory
    public static Matcher<TGAPrimitive> data(Matcher<Element> ... matchers) throws SAXException, IOException, DocumentException {
        return new AdaptingMatcher<TGAPrimitive, Iterable<Element>>(new Matcher[]{HasElementsContainingInOrder.hasElementsInOrder(matchers)}){

            public Iterable<Element> get(TGAPrimitive in) throws CannotAdaptException {
                if (in instanceof TPost) {
                    return ((TPost)in).getData().getAny();
                }
                if (in instanceof TGetSyncResponse) {
                    return ((TGetSyncResponse)in).getData().getAny();
                }
                return null;
            }
        };
    }

    @HamSandwichFactory
    public static Matcher<TData> tData(Matcher<Element> ... matchers) {
        return new AdaptingMatcher<TData, Iterable<Element>>(new Matcher[]{HasElementsContainingInOrder.hasElementsInOrder(matchers)}){

            public Iterable<Element> get(TData in) throws CannotAdaptException {
                return in.getAny();
            }
        };
    }
}

