/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.gaPrimitives.tests;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.custommonkey.xmlunit.XMLUnit;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.SAXReader;
import org.hamcrest.DiagnosingMatcherAssert;
import org.hamcrest.Matcher;
import org.junit.BeforeClass;
import org.junit.Test;
import org.ow2.choreos.xsa.xsb.gaPrimitives.GAMessageFactory;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TPolicy;
import org.ow2.choreos.xsa.xsb.specifications.parsers.ga.TCoupling;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.GaMessage;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.ObjectFactory;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TData;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TEndGet;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TEndGetAsync;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TGetAsync;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TGetSync;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TPost;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TScope;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TSetupGet;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TSetupGetResponse;
import org.ow2.choreos.xsa.xsb.utils.xml.IsXMLDocumentEquivalent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TestGAMessageBuild {
    private GAMessageFactory factory = new GAMessageFactory();
    private ObjectFactory jaxbFactory = new ObjectFactory();
    private static Element eltMainscope;
    private static Element eltSubscope;
    private static Element eltSubsubscope;
    private static DOMElement eltData;
    private static String callback;
    private static ClassLoader loader;

    @BeforeClass
    public static void beforeTestClass() throws SAXException, IOException, DocumentException {
        eltMainscope = XMLUnit.buildControlDocument((String)"<mainscopeId>id1</mainscopeId>").getDocumentElement();
        eltSubscope = XMLUnit.buildControlDocument((String)"<subscopeId>id2</subscopeId>").getDocumentElement();
        eltSubsubscope = XMLUnit.buildControlDocument((String)"<subsubscopeId>id3</subsubscopeId>").getDocumentElement();
        DOMDocumentFactory domFactory = new DOMDocumentFactory();
        SAXReader reader = new SAXReader((DocumentFactory)domFactory);
        eltData = (DOMElement)reader.read((Reader)new StringReader("<aData>some text</aData>")).getRootElement().createCopy();
        callback = "callback1";
        loader = TestGAMessageBuild.class.getClassLoader();
    }

    @Test
    public void testPost() throws TransformerFactoryConfigurationError, TransformerException, JAXBException, ParserConfigurationException, URISyntaxException, IOException, SAXException, DocumentException {
        TPost postMessage = new TPost();
        postMessage.setCoupling(TCoupling.STRONG);
        TScope scope = this.factory.buildTScopeFromDOM(eltMainscope, eltSubscope, eltSubsubscope);
        postMessage.setScope(scope);
        postMessage.setCorrelation("correlation1");
        postMessage.setLease(this.factory.buildTLease(-1));
        TData data = this.factory.buildTData(new DOMElement[]{eltData});
        postMessage.setData(data);
        ArrayList<TPost> prims = new ArrayList<TPost>();
        prims.add(postMessage);
        GaMessage message = this.factory.buildJAXBGAMessage(prims);
        Document result = this.factory.buildDocument(message);
        DiagnosingMatcherAssert.assertThat((Object)result, (Matcher)IsXMLDocumentEquivalent.xmlDocumentEquivalent((ClassLoader)loader, (String)"GAPost.xml"));
    }

    @Test
    public void testSetupGet() throws TransformerFactoryConfigurationError, TransformerException, JAXBException, ParserConfigurationException, URISyntaxException, IOException, SAXException, DocumentException {
        TSetupGet setupGetMessage = new TSetupGet();
        setupGetMessage.setCoupling(TCoupling.WEAK);
        TScope scope = this.factory.buildTScopeFromDOM(eltMainscope, eltSubscope, eltSubsubscope);
        setupGetMessage.setScope(scope);
        setupGetMessage.setCorrelation("correlation1");
        setupGetMessage.setHandle("handle1");
        ArrayList<TSetupGet> prims = new ArrayList<TSetupGet>();
        prims.add(setupGetMessage);
        GaMessage message = this.factory.buildJAXBGAMessage(prims);
        Document result = this.factory.buildDocument(message);
        DiagnosingMatcherAssert.assertThat((Object)result, (Matcher)IsXMLDocumentEquivalent.xmlDocumentEquivalent((ClassLoader)loader, (String)"GASetupGet.xml"));
    }

    @Test
    public void testGetAsync1() throws TransformerFactoryConfigurationError, TransformerException, JAXBException, ParserConfigurationException, URISyntaxException, IOException, SAXException, DocumentException {
        TGetAsync getAsync1Message = new TGetAsync();
        getAsync1Message.setCoupling(TCoupling.ANY);
        getAsync1Message.setHandle("handle1");
        getAsync1Message.setCallback(callback);
        ArrayList<TGetAsync> prims = new ArrayList<TGetAsync>();
        prims.add(getAsync1Message);
        GaMessage message = this.factory.buildJAXBGAMessage(prims);
        Document result = this.factory.buildDocument(message);
        DiagnosingMatcherAssert.assertThat((Object)result, (Matcher)IsXMLDocumentEquivalent.xmlDocumentEquivalent((ClassLoader)loader, (String)"GAGetAsync1.xml"));
    }

    @Test
    public void testGetAsync2() throws TransformerFactoryConfigurationError, TransformerException, JAXBException, ParserConfigurationException, URISyntaxException, IOException, SAXException, DocumentException {
        TGetAsync getAsyncMessage = new TGetAsync();
        getAsyncMessage.setCoupling(TCoupling.ANY);
        getAsyncMessage.setHandle("handle1");
        getAsyncMessage.setCallback(callback);
        ArrayList<TGetAsync> prims = new ArrayList<TGetAsync>();
        prims.add(getAsyncMessage);
        GaMessage message = this.factory.buildJAXBGAMessage(prims);
        Document result = this.factory.buildDocument(message);
        DiagnosingMatcherAssert.assertThat((Object)result, (Matcher)IsXMLDocumentEquivalent.xmlDocumentEquivalent((ClassLoader)loader, (String)"GAGetAsync2.xml"));
    }

    @Test
    public void testGetSync1() throws TransformerFactoryConfigurationError, TransformerException, JAXBException, ParserConfigurationException, URISyntaxException, IOException, SAXException, DocumentException {
        TGetSync getSyncMessage = new TGetSync();
        getSyncMessage.setCoupling(TCoupling.WEAK);
        getSyncMessage.setHandle("handle1");
        getSyncMessage.setPolicy(TPolicy.COPY);
        getSyncMessage.setTimeout(this.factory.buildTWait(-1));
        ArrayList<TGetSync> prims = new ArrayList<TGetSync>();
        prims.add(getSyncMessage);
        GaMessage message = this.factory.buildJAXBGAMessage(prims);
        Document result = this.factory.buildDocument(message);
        DiagnosingMatcherAssert.assertThat((Object)result, (Matcher)IsXMLDocumentEquivalent.xmlDocumentEquivalent((ClassLoader)loader, (String)"GAGetSync1.xml"));
    }

    @Test
    public void testGetSync2() throws TransformerFactoryConfigurationError, TransformerException, JAXBException, ParserConfigurationException, URISyntaxException, IOException, SAXException, DocumentException {
        TGetSync getSyncMessage = new TGetSync();
        getSyncMessage.setCoupling(TCoupling.WEAK);
        getSyncMessage.setHandle("handle1");
        getSyncMessage.setPolicy(TPolicy.COPY_ALL);
        getSyncMessage.setTimeout(this.factory.buildTWait(100));
        ArrayList<TGetSync> prims = new ArrayList<TGetSync>();
        prims.add(getSyncMessage);
        GaMessage message = this.factory.buildJAXBGAMessage(prims);
        Document result = this.factory.buildDocument(message);
        DiagnosingMatcherAssert.assertThat((Object)result, (Matcher)IsXMLDocumentEquivalent.xmlDocumentEquivalent((ClassLoader)loader, (String)"GAGetSync2.xml"));
    }

    @Test
    public void testEndGet() throws TransformerFactoryConfigurationError, TransformerException, JAXBException, ParserConfigurationException, URISyntaxException, IOException, SAXException, DocumentException {
        TEndGet endGetMessage = new TEndGet();
        endGetMessage.setHandle("handle1");
        ArrayList<TEndGet> prims = new ArrayList<TEndGet>();
        prims.add(endGetMessage);
        GaMessage message = this.factory.buildJAXBGAMessage(prims);
        Document result = this.factory.buildDocument(message);
        DiagnosingMatcherAssert.assertThat((Object)result, (Matcher)IsXMLDocumentEquivalent.xmlDocumentEquivalent((ClassLoader)loader, (String)"GAEndGet.xml"));
    }

    @Test
    public void testEndGetAsync() throws TransformerFactoryConfigurationError, TransformerException, JAXBException, ParserConfigurationException, URISyntaxException, IOException, SAXException, DocumentException {
        TEndGetAsync endGetMessage = new TEndGetAsync();
        endGetMessage.setHandle("handle1");
        ArrayList<TEndGetAsync> prims = new ArrayList<TEndGetAsync>();
        prims.add(endGetMessage);
        GaMessage message = this.factory.buildJAXBGAMessage(prims);
        Document result = this.factory.buildDocument(message);
        DiagnosingMatcherAssert.assertThat((Object)result, (Matcher)IsXMLDocumentEquivalent.xmlDocumentEquivalent((ClassLoader)loader, (String)"GAEndGetAsync.xml"));
    }

    @Test
    public void testSetupGetResponse() throws TransformerFactoryConfigurationError, TransformerException, JAXBException, ParserConfigurationException, URISyntaxException, IOException, SAXException, DocumentException {
        TSetupGetResponse setupGetResponseMessage = new TSetupGetResponse();
        setupGetResponseMessage.setHandle("handle1");
        ArrayList<TSetupGetResponse> prims = new ArrayList<TSetupGetResponse>();
        prims.add(setupGetResponseMessage);
        GaMessage message = this.factory.buildJAXBGAMessage(prims);
        Document result = this.factory.buildDocument(message);
        DiagnosingMatcherAssert.assertThat((Object)result, (Matcher)IsXMLDocumentEquivalent.xmlDocumentEquivalent((ClassLoader)loader, (String)"GASetupGetResponse.xml"));
    }
}

