/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.gaPrimitives.tests;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.custommonkey.xmlunit.XMLUnit;
import org.dom4j.DocumentException;
import org.hamcrest.DiagnosingMatcherAssert;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.BeforeClass;
import org.junit.Test;
import org.ow2.choreos.xsa.xsb.gaPrimitives.GAMessageFactory;
import org.ow2.choreos.xsa.xsb.gaPrimitives.tests.GAMessageMatchers;
import org.ow2.choreos.xsa.xsb.gaPrimitives.tests.TestGAMessageBuild;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TPolicy;
import org.ow2.choreos.xsa.xsb.specifications.parsers.ga.TCoupling;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.GaMessage;
import org.ow2.choreos.xsa.xsb.utils.xml.IsXMLDocumentEquivalent;
import org.ow2.choreos.xsa.xsb.utils.xml.IsXMLElementEquivalent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TestGAPrimitivesRead {
    private GAMessageFactory factory = new GAMessageFactory();
    private static Document eltMainscope;
    private static Document eltSubscope;
    private static Document eltSubsubscope;
    private static Document eltData;
    private static ClassLoader loader;

    @BeforeClass
    public static void beforeTestClass() throws SAXException, IOException, DocumentException {
        eltMainscope = XMLUnit.buildControlDocument((String)"<mainscopeId>id1</mainscopeId>");
        eltSubscope = XMLUnit.buildControlDocument((String)"<subscopeId>id2</subscopeId>");
        eltSubsubscope = XMLUnit.buildControlDocument((String)"<subsubscopeId>id3</subsubscopeId>");
        eltData = XMLUnit.buildControlDocument((String)"<aData>some text</aData>");
        loader = TestGAMessageBuild.class.getClassLoader();
    }

    @Test
    public void TestEndGetRead() throws JAXBException, URISyntaxException, ParserConfigurationException, IOException, SAXException, DocumentException {
        Matcher<GaMessage> matcher = GAMessageMatchers.gaMessage(GAMessageMatchers.endGet(GAMessageMatchers.handle(IsEqual.equalTo((Object)"handle1"))));
        this.processXmlFile("GAEndGet.xml", matcher);
    }

    @Test
    public void TestGetAsync1Read() throws JAXBException, URISyntaxException, ParserConfigurationException, IOException, SAXException, DocumentException {
        Matcher<GaMessage> matcher = GAMessageMatchers.gaMessage(GAMessageMatchers.getAsync(GAMessageMatchers.coupling(TCoupling.ANY), GAMessageMatchers.handle(IsEqual.equalTo((Object)"handle1")), GAMessageMatchers.callback("callback1")));
        this.processXmlFile("GAGetAsync1.xml", matcher);
    }

    @Test
    public void TestGetAsync2Read() throws JAXBException, URISyntaxException, ParserConfigurationException, IOException, SAXException, DocumentException {
        Matcher<GaMessage> matcher = GAMessageMatchers.gaMessage(GAMessageMatchers.getAsync(GAMessageMatchers.coupling(TCoupling.ANY), GAMessageMatchers.handle(IsEqual.equalTo((Object)"handle1")), GAMessageMatchers.callback("callback1")));
        this.processXmlFile("GAGetAsync2.xml", matcher);
    }

    @Test
    public void TestGetSync1Read() throws JAXBException, URISyntaxException, ParserConfigurationException, IOException, SAXException, DocumentException {
        Matcher<GaMessage> matcher = GAMessageMatchers.gaMessage(GAMessageMatchers.getSync(GAMessageMatchers.coupling(TCoupling.WEAK), GAMessageMatchers.handle(IsEqual.equalTo((Object)"handle1")), GAMessageMatchers.policy(TPolicy.COPY), GAMessageMatchers.timeout(GAMessageMatchers.timeoutWait())));
        this.processXmlFile("GAGetSync1.xml", matcher);
    }

    @Test
    public void TestGetSync2Read() throws JAXBException, URISyntaxException, ParserConfigurationException, IOException, SAXException, DocumentException {
        Matcher<GaMessage> matcher = GAMessageMatchers.gaMessage(GAMessageMatchers.getSync(GAMessageMatchers.coupling(TCoupling.WEAK), GAMessageMatchers.handle(IsEqual.equalTo((Object)"handle1")), GAMessageMatchers.policy(TPolicy.COPY_ALL), GAMessageMatchers.timeout(GAMessageMatchers.timeoutValue(100))));
        this.processXmlFile("GAGetSync2.xml", matcher);
    }

    @Test
    public void TestGetSyncResponseRead() throws JAXBException, URISyntaxException, ParserConfigurationException, IOException, SAXException, DocumentException {
        Matcher<GaMessage> matcher = GAMessageMatchers.gaMessage(GAMessageMatchers.getSyncResponse(GAMessageMatchers.coupling(TCoupling.STRONG), GAMessageMatchers.handle(IsEqual.equalTo((Object)"handle1")), GAMessageMatchers.data(IsXMLElementEquivalent.xmlElementEquivalent((Document)eltData))));
        this.processXmlFile("GAGetSyncResponse.xml", matcher);
    }

    @Test
    public void TestPostRead() throws JAXBException, URISyntaxException, ParserConfigurationException, IOException, SAXException, DocumentException {
        Matcher<GaMessage> matcher = GAMessageMatchers.gaMessage(GAMessageMatchers.post(GAMessageMatchers.coupling(TCoupling.STRONG), GAMessageMatchers.scope((Matcher<Element>)IsXMLElementEquivalent.xmlElementEquivalent((Document)eltMainscope), (Matcher<Element>)IsXMLElementEquivalent.xmlElementEquivalent((Document)eltSubscope), (Matcher<Element>)IsXMLElementEquivalent.xmlElementEquivalent((Document)eltSubsubscope)), GAMessageMatchers.data(IsXMLElementEquivalent.xmlElementEquivalent((Document)eltData)), GAMessageMatchers.correlation(IsEqual.equalTo((Object)"correlation1"))));
        this.processXmlFile("GAPost.xml", matcher);
    }

    @Test
    public void TestSetupGetRead() throws JAXBException, URISyntaxException, ParserConfigurationException, IOException, SAXException, DocumentException {
        Matcher<GaMessage> matcher = GAMessageMatchers.gaMessage(GAMessageMatchers.setupGet(GAMessageMatchers.coupling(TCoupling.WEAK), GAMessageMatchers.scope((Matcher<Element>)IsXMLElementEquivalent.xmlElementEquivalent((Document)eltMainscope), (Matcher<Element>)IsXMLElementEquivalent.xmlElementEquivalent((Document)eltSubscope), (Matcher<Element>)IsXMLElementEquivalent.xmlElementEquivalent((Document)eltSubsubscope)), GAMessageMatchers.handle(IsEqual.equalTo((Object)"handle1")), GAMessageMatchers.correlation(IsEqual.equalTo((Object)"correlation1"))));
        this.processXmlFile("GASetupGet.xml", matcher);
    }

    protected void processXmlFile(String filename, Matcher<GaMessage> matcher) throws URISyntaxException, JAXBException, ParserConfigurationException, IOException, SAXException, DocumentException {
        File source = new File(this.getClass().getClassLoader().getResource(filename).toURI());
        GaMessage message = this.factory.buildGAMessage(source);
        DiagnosingMatcherAssert.assertThat((Object)message, matcher);
        Document docResult = this.factory.buildDocument(message);
        DiagnosingMatcherAssert.assertThat((Object)docResult, (Matcher)IsXMLDocumentEquivalent.xmlDocumentEquivalent((File)source));
    }
}

